/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.tasklet;

import com.sonatype.nexus.db.migrator.utils.PathQualifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class UnzipArchivesTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnzipArchivesTasklet.class);
    private final PathQualifier pathQualifier;
    private static final String BACKUP_FOLDER_EXTENSION = ".bak";

    public UnzipArchivesTasklet(PathQualifier pathQualifier) {
        this.pathQualifier = pathQualifier;
    }

    @Override
    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        String destinationPath = this.pathQualifier.getOrientFolderPath();
        File destinationFolder = new File(destinationPath);
        String componentDestination = this.findDestinationPath("component", destinationPath);
        String configDestination = this.findDestinationPath("config", destinationPath);
        String securityDestination = this.findDestinationPath("security", destinationPath);
        String componentPath = this.locateBackupFilePath("component", destinationFolder);
        String configPath = this.locateBackupFilePath("config", destinationFolder);
        String securityPath = this.locateBackupFilePath("security", destinationFolder);
        this.unzip(componentPath, componentDestination);
        this.unzip(configPath, configDestination);
        this.unzip(securityPath, securityDestination);
        return RepeatStatus.FINISHED;
    }

    private String findDestinationPath(String path, String destinationPath) {
        return destinationPath + File.separator + path;
    }

    private String locateBackupFilePath(String zipPath, File destinationFolder) {
        FilenameFilter filter = (destFolder, name) -> name.startsWith(zipPath) && name.endsWith(BACKUP_FOLDER_EXTENSION);
        File[] zipFiles = destinationFolder.listFiles(filter);
        if (zipFiles != null) {
            return zipFiles[0].getAbsolutePath();
        }
        return null;
    }

    private void unzip(String zip, String destination) throws IOException {
        File destinationFolder = new File(destination);
        log.info("Unzipping " + zip + " to " + destination);
        byte[] buffer = new byte[1024];
        try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(Paths.get(zip, new String[0]), new OpenOption[0]));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File newFile = this.zipSlipProtect(destinationFolder, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (this.isNotAndDidNotMakeDirectories(newFile)) {
                        throw new IOException("Failed to create directory " + newFile.getAbsolutePath());
                    }
                } else {
                    File parent = newFile.getParentFile();
                    if (this.isNotAndDidNotMakeDirectories(parent)) {
                        throw new IOException("Failed to create directory " + parent.getAbsolutePath());
                    }
                    try (FileOutputStream fileOutputStream = new FileOutputStream(newFile);){
                        while (zipInputStream.available() > 0) {
                            this.writeIfHasData(zipInputStream, buffer, fileOutputStream);
                        }
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        log.info("Unzipped " + zip + " successfully");
    }

    private File zipSlipProtect(File destinationFolder, ZipEntry zipEntry) throws IOException {
        File destinationFile = new File(destinationFolder, zipEntry.getName());
        String destinationFolderPath = destinationFolder.getCanonicalPath();
        String destinationFilePath = destinationFile.getCanonicalPath();
        if (!destinationFilePath.startsWith(destinationFolderPath + File.separator)) {
            throw new IOException("Entry is outside of the target directory: " + zipEntry.getName());
        }
        return destinationFile;
    }

    private boolean isNotAndDidNotMakeDirectories(File file) {
        return !file.isDirectory() && !file.mkdirs();
    }

    private void writeIfHasData(ZipInputStream zipInputStream, byte[] buffer, FileOutputStream fileOutputStream) throws IOException {
        int len = zipInputStream.read(buffer);
        if (len > 0) {
            fileOutputStream.write(buffer, 0, len);
        }
    }
}

