/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.utils;

import com.sonatype.nexus.db.migrator.entity.AssetEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetAndAssetBlobUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetAndAssetBlobUtils.class);
    private static final Map<String, Set<Integer>> savedAssets = new HashMap<String, Set<Integer>>();
    private static final Map<String, Map<String, Integer>> savedAssetBlobIds = new HashMap<String, Map<String, Integer>>();
    private static final Map<String, Set<Integer>> assetIdsWithDuplicatedBlob = new HashMap<String, Set<Integer>>();

    private AssetAndAssetBlobUtils() {
    }

    public static Set<Integer> getSavedAssets(String format) {
        return savedAssets.getOrDefault(format, new HashSet());
    }

    public static void removeSavedAssets(String format, Integer assetId) {
        Set<Integer> assets = savedAssets.get(format);
        if (CollectionUtils.isNotEmpty(assets)) {
            assets.remove(assetId);
        }
    }

    public static void removeSavedAssets(String format, Set<Integer> assetIds) {
        Set<Integer> assets = savedAssets.get(format);
        if (CollectionUtils.isNotEmpty(assets)) {
            assets.removeAll(assetIds);
        }
    }

    public static Map<String, Integer> getSavedAssetBlobIds(String format) {
        return savedAssetBlobIds.getOrDefault(format, new HashMap());
    }

    public static void removeSavedAssetBlobId(String format, String blobRefs) {
        Map<String, Integer> blobs = savedAssetBlobIds.get(format);
        if (MapUtils.isNotEmpty(blobs)) {
            blobs.remove(blobRefs);
        }
    }

    public static void removeSavedAssetBlobId(String format, Set<String> blobRefs) {
        Map<String, Integer> blobs = savedAssetBlobIds.get(format);
        if (MapUtils.isNotEmpty(blobs)) {
            blobs.keySet().removeAll(blobRefs);
        }
    }

    public static void saveAssetBlobIds(List<AssetEntity> newItems, String format) {
        savedAssetBlobIds.compute(format, (k, v) -> {
            if (v == null) {
                v = new HashMap<String, Integer>();
            }
            v.putAll(newItems.stream().collect(Collectors.toMap(AssetEntity::getBlobRef, AssetEntity::getAssetBlobId)));
            return v;
        });
    }

    public static void saveAssets(List<AssetEntity> newItems, String format) {
        savedAssets.compute(format, (k, v) -> {
            if (v == null) {
                v = new HashSet();
            }
            v.addAll(newItems.stream().map(AssetEntity::getAssetId).collect(Collectors.toSet()));
            return v;
        });
    }

    public static Set<Integer> getAssetIdsWithDuplicatedBlob(String format) {
        return assetIdsWithDuplicatedBlob.getOrDefault(format, new HashSet());
    }

    @Generated
    public static Map<String, Set<Integer>> getSavedAssets() {
        return savedAssets;
    }

    @Generated
    public static Map<String, Map<String, Integer>> getSavedAssetBlobIds() {
        return savedAssetBlobIds;
    }

    @Generated
    public static Map<String, Set<Integer>> getAssetIdsWithDuplicatedBlob() {
        return assetIdsWithDuplicatedBlob;
    }
}

