/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.utils;

import lombok.Generated;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateParserUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateParserUtil.class);

    public static DateTime parseDateOrNow(Object input) {
        if (input instanceof DateTime) {
            return (DateTime)input;
        }
        if (input instanceof Number) {
            long millis = ((Number)input).longValue();
            if (millis > 0L) {
                return new DateTime(((Number)input).longValue(), DateTimeZone.UTC);
            }
        } else if (input instanceof String) {
            try {
                return DateTime.parse((String)input);
            }
            catch (IllegalArgumentException e) {
                try {
                    return DateTime.parse((String)input, DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss").withZone(DateTimeZone.UTC));
                }
                catch (IllegalArgumentException e1) {
                    log.warn("Expected a date in a string, but could not parse: {}", input);
                }
            }
        } else {
            log.warn("Expected a date, but could not detect data type: {}", input);
        }
        return DateTime.now(DateTimeZone.UTC);
    }

    @Generated
    private DateParserUtil() {
    }
}

