/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.utils;

import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.utils.RepositoryUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.quartz.JobDataMap;

public class QuartzFilterUtils {
    private static final String TYPE_ID_ATTRIBUTE = ".typeId";
    private static final String SCHEDULE_TYPE_ATTRIBUTE = "schedule.type";
    private static final String SCHEDULE_TYPE_ATTRIBUTE_NOW = "now";
    private static final String REPOSITORY_NAME_ATTRIBUTE = "repositoryName";
    private static final String REPOSITORY_TASK_TYPE = "repository";
    private static final String MOVE_NAME_ATTRIBUTE = "move";
    private static final String TRIGGER_STATE_BLOCKED = "BLOCKED";
    private static final String TRIGGER_STATE_WAITING = "WAITING";
    private static final Set<String> filteredJobNames = new HashSet<String>();

    private QuartzFilterUtils() {
    }

    public static void addFilteredJobName(String jobName) {
        filteredJobNames.add(jobName);
    }

    public static boolean isJobFiltered(String jobName) {
        return filteredJobNames.contains(jobName);
    }

    public static boolean containsFilteredRepository(Map<String, String> jobData) {
        if (jobData.containsKey(REPOSITORY_NAME_ATTRIBUTE)) {
            String[] repositoryNames = jobData.get(REPOSITORY_NAME_ATTRIBUTE).split(",");
            return RepositoryUtils.isEachRepositoryFiltered(Arrays.asList(repositoryNames));
        }
        return false;
    }

    public static boolean containsFilteredRepository(JobDataMap jobData) {
        if (jobData.containsKey(REPOSITORY_NAME_ATTRIBUTE)) {
            String[] repositoryNames = jobData.getString(REPOSITORY_NAME_ATTRIBUTE).split(",");
            return RepositoryUtils.isEachRepositoryFiltered(Arrays.asList(repositoryNames));
        }
        return false;
    }

    public static boolean shouldTaskBeSkipped(Map<String, String> jobData, boolean contentMigration) {
        if (jobData.containsKey(TYPE_ID_ATTRIBUTE)) {
            String[] typeIdItems = jobData.get(TYPE_ID_ATTRIBUTE).split("\\.");
            return QuartzFilterUtils.shouldTaskBeSkipped(typeIdItems, contentMigration);
        }
        return false;
    }

    public static boolean shouldTaskBeSkipped(JobDataMap jobData, boolean contentMigration) {
        if (jobData.containsKey(TYPE_ID_ATTRIBUTE)) {
            String[] typeIdItems = jobData.getString(TYPE_ID_ATTRIBUTE).split("\\.");
            return QuartzFilterUtils.shouldTaskBeSkipped(typeIdItems, contentMigration);
        }
        return false;
    }

    private static boolean shouldTaskBeSkipped(String[] typeIdItems, boolean contentMigration) {
        if (typeIdItems.length < 2) {
            return false;
        }
        boolean isRepositoryTask = REPOSITORY_TASK_TYPE.equals(typeIdItems[0]) && !MOVE_NAME_ATTRIBUTE.equals(typeIdItems[1]);
        String format = typeIdItems[1].equals("maven") ? Format.MAVEN2.name() : typeIdItems[1];
        return isRepositoryTask && (!contentMigration || Format.isNotSupportedFormat(format));
    }

    public static boolean shouldTriggerBeSkipped(String triggerState, Map<String, String> jobDataMap) {
        return QuartzFilterUtils.isWaitingOrBlockedStatus(triggerState) && jobDataMap.containsKey(SCHEDULE_TYPE_ATTRIBUTE) && SCHEDULE_TYPE_ATTRIBUTE_NOW.equals(jobDataMap.get(SCHEDULE_TYPE_ATTRIBUTE));
    }

    public static boolean shouldTriggerBeSkipped(String triggerState, JobDataMap jobDataMap) {
        return QuartzFilterUtils.isWaitingOrBlockedStatus(triggerState) && jobDataMap.containsKey(SCHEDULE_TYPE_ATTRIBUTE) && SCHEDULE_TYPE_ATTRIBUTE_NOW.equals(jobDataMap.getString(SCHEDULE_TYPE_ATTRIBUTE));
    }

    private static boolean isWaitingOrBlockedStatus(String triggerState) {
        return TRIGGER_STATE_BLOCKED.equals(triggerState) || TRIGGER_STATE_WAITING.equals(triggerState);
    }
}

