/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.validator;

import com.sonatype.nexus.db.migrator.config.Constants;
import com.sonatype.nexus.db.migrator.exception.MigratorJobParametersInvalidException;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.JobParametersValidator;

public class JobParametersValidatorImpl
implements JobParametersValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobParametersValidatorImpl.class);
    public static final String MIGRATION_TYPE_REQUIRED = "Migration type required migration_type";
    public static final String WRONG_MIGRATION_TYPE = "Wrong migration type '%s'. List of available migration types: %s";
    public static final String URL_FOR_H2_WILL_BE_IGNORED = "The data source URL will be ignored for the embedded H2 database. The database files will be created in the same folder where the migrator jar was placed.";
    public static final String DB_URL_IS_REQUIRED_FOR_POSTGRE_SQL = "DB URL is required for PostgreSQL";
    public static final String INVALID_CONTENT_MIGRATION_PARAM = "The content_migration parameter is invalid! Please set content_migration=true to migrate components or content_migration=false to skip components migration";
    public static final String INVALID_FORCE_PARAM = "The force parameter is invalid! Please set force=true to replace existed h2 database";
    public static final String INVALID_SHUTDOWN_COMPACT_PARAM = "The shutdown_compact parameter is invalid! Please set shutdown_compact=true to compact H2 Content database or shutdown_compact=false to skip H2 Content database compression";

    @Override
    public void validate(JobParameters parametersToValidate) throws JobParametersInvalidException {
        Map<String, JobParameter> jobParameters = ConvertUtils.convertJobParametersToMap(parametersToValidate);
        if (jobParameters.containsKey("healthcheck")) {
            log.info("Migrator started in health-check mode. Skip other parameters validation");
            return;
        }
        JobParameter migrationTypeParameter = jobParameters.get("migration_type");
        JobParameter dataSourceURL = jobParameters.get("db_url");
        JobParameter componentMigration = jobParameters.get("content_migration");
        JobParameter shutdownCompact = jobParameters.get("shutdown_compact");
        JobParameter force = jobParameters.get("force");
        this.checkIfMigrationTypeIsValid(migrationTypeParameter);
        this.checkIfComponentMigrationIsValid(componentMigration);
        this.checkIfForceIsValid(force);
        this.checkIfShutdownCompactIsValid(shutdownCompact);
        this.checkIfOutputUrlSetCorrectly(migrationTypeParameter.toString(), dataSourceURL);
    }

    private void checkIfMigrationTypeIsValid(JobParameter migrationTypeParameter) throws JobParametersInvalidException {
        if (migrationTypeParameter == null) {
            throw new MigratorJobParametersInvalidException(MIGRATION_TYPE_REQUIRED);
        }
        String dataSourceType = migrationTypeParameter.toString();
        if (!Constants.SUPPORTED_MIGRATION_TYPES.contains(dataSourceType)) {
            throw new MigratorJobParametersInvalidException(String.format(WRONG_MIGRATION_TYPE, dataSourceType, Constants.SUPPORTED_MIGRATION_TYPES.toString()));
        }
    }

    private void checkIfOutputUrlSetCorrectly(String migrationType, JobParameter dataSourceURL) throws JobParametersInvalidException {
        if (Constants.isPostgresMigration(migrationType)) {
            if (dataSourceURL == null) {
                throw new MigratorJobParametersInvalidException(DB_URL_IS_REQUIRED_FOR_POSTGRE_SQL);
            }
        } else if ("h2".equalsIgnoreCase(migrationType) && dataSourceURL != null) {
            log.info(URL_FOR_H2_WILL_BE_IGNORED);
        }
    }

    private void checkIfComponentMigrationIsValid(JobParameter componentMigration) throws JobParametersInvalidException {
        if (this.isNotBoolean(componentMigration)) {
            throw new MigratorJobParametersInvalidException(INVALID_CONTENT_MIGRATION_PARAM);
        }
    }

    private void checkIfForceIsValid(JobParameter force) throws JobParametersInvalidException {
        if (this.isNotBoolean(force)) {
            throw new MigratorJobParametersInvalidException(INVALID_FORCE_PARAM);
        }
    }

    private void checkIfShutdownCompactIsValid(JobParameter shutdownCompact) throws JobParametersInvalidException {
        if (this.isNotBoolean(shutdownCompact)) {
            throw new MigratorJobParametersInvalidException(INVALID_SHUTDOWN_COMPACT_PARAM);
        }
    }

    private boolean isNotBoolean(JobParameter jobParameter) {
        return jobParameter != null && !jobParameter.toString().equalsIgnoreCase(Boolean.TRUE.toString()) && !jobParameter.toString().equalsIgnoreCase(Boolean.FALSE.toString());
    }
}

