/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.validator;

import com.sonatype.nexus.db.migrator.exception.MigratorJobParametersInvalidException;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;

public class TargetDatabaseValidator
implements JobParametersValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TargetDatabaseValidator.class);
    public static final String TARGET_DB_HAS_CONTENT_MESSAGE = "Target database has content. If you want to delete all content in your target database, you have to rerun migration with '--force=true' flag.";
    public static final String SHOW_TABLES = "SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '%s'";
    public static final int BATCH_TABLES_COUNT = 6;
    private JdbcTemplate destJdbc;

    @Override
    public void validate(JobParameters jobParameters) throws JobParametersInvalidException {
        Map<String, JobParameter> parameters = ConvertUtils.convertJobParametersToMap(jobParameters);
        String forceParam = parameters.get("force").toString();
        if (this.databaseHasContent()) {
            if (Boolean.TRUE.toString().equals(forceParam)) {
                log.info("The --force parameter is active, tables of the target database will be dropped.");
            } else {
                throw new MigratorJobParametersInvalidException(TARGET_DB_HAS_CONTENT_MESSAGE);
            }
        }
    }

    private boolean databaseHasContent() {
        Integer count;
        String schemaName;
        try {
            DataSource dataSource = this.destJdbc.getDataSource();
            if (dataSource == null) {
                throw new RuntimeException("Can't get data source from JDBC URL");
            }
            schemaName = dataSource.getConnection().getSchema();
        }
        catch (SQLException e) {
            throw new RuntimeException("Database access error: " + e.getMessage());
        }
        if (StringUtils.isBlank(schemaName)) {
            schemaName = "public";
        }
        return !Objects.equals(count = this.destJdbc.queryForObject(String.format(SHOW_TABLES, schemaName), Integer.class), 6);
    }

    @Autowired
    @Qualifier(value="destinationJdbcTemplate")
    public void setDestJdbc(JdbcTemplate destJdbc) {
        this.destJdbc = destJdbc;
    }
}

