/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.writer;

import com.sonatype.nexus.db.migrator.entity.ComponentEntity;
import com.sonatype.nexus.db.migrator.entity.ComponentTagEntity;
import com.sonatype.nexus.db.migrator.entity.Entity;
import com.sonatype.nexus.db.migrator.utils.ComponentIdUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcBatchItemWriter;

public class ComponentWriter
implements ItemWriter<Entity> {
    private final JdbcBatchItemWriter<Entity> componentJdbcWriter;
    private final String insertComponentSql;
    private final JdbcBatchItemWriter<Entity> componentTagJdbcWriter;
    private final String insertComponentTagSql;

    @Override
    public void write(List<? extends Entity> items) throws Exception {
        Map<String, List<ComponentEntity>> components = items.stream().map(ComponentEntity.class::cast).collect(Collectors.groupingBy(ComponentEntity::getFormat));
        for (Map.Entry<String, List<ComponentEntity>> entry : components.entrySet()) {
            this.writeByFormat(entry.getKey(), entry.getValue());
        }
    }

    private void writeByFormat(String format, List<ComponentEntity> items) throws Exception {
        this.componentJdbcWriter.setSql(this.insertComponentSql.replace("${format}", format));
        this.componentJdbcWriter.write(items);
        List<ComponentTagEntity> componentTagEntities = ComponentWriter.getComponentTagEntities(items);
        if (!componentTagEntities.isEmpty()) {
            this.componentTagJdbcWriter.setSql(this.insertComponentTagSql.replace("${format}", format));
            this.componentTagJdbcWriter.write(componentTagEntities);
        }
        List<Integer> savedComponentIds = items.stream().map(ComponentEntity::getComponentId).collect(Collectors.toList());
        ComponentIdUtils.addSavedComponentIds(format, savedComponentIds);
    }

    private static List<ComponentTagEntity> getComponentTagEntities(List<ComponentEntity> items) {
        return items.stream().filter(i -> CollectionUtils.isNotEmpty(i.getTags())).map(ComponentWriter::buildComponentTagEntity).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<ComponentTagEntity> buildComponentTagEntity(ComponentEntity component) {
        return component.getTags().stream().map(tag -> ((ComponentTagEntity.ComponentTagEntityBuilder)((ComponentTagEntity.ComponentTagEntityBuilder)((ComponentTagEntity.ComponentTagEntityBuilder)ComponentTagEntity.builder().format(component.getFormat())).componentId(component.getComponentId())).tagId((int)tag)).build()).collect(Collectors.toList());
    }

    @Generated
    public ComponentWriter(JdbcBatchItemWriter<Entity> componentJdbcWriter, String insertComponentSql, JdbcBatchItemWriter<Entity> componentTagJdbcWriter, String insertComponentTagSql) {
        this.componentJdbcWriter = componentJdbcWriter;
        this.insertComponentSql = insertComponentSql;
        this.componentTagJdbcWriter = componentTagJdbcWriter;
        this.insertComponentTagSql = insertComponentTagSql;
    }
}

