/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.writer;

import com.sonatype.nexus.db.migrator.entity.Entity;
import com.sonatype.nexus.db.migrator.entity.QuartzTriggerEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzTriggerType;
import com.sonatype.nexus.db.migrator.exception.WriteQuartzTriggerException;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.batch.item.ItemWriter;
import org.springframework.dao.DataIntegrityViolationException;

public class CompositeQuartzTriggerWriter
implements ItemWriter<Entity> {
    private final ItemWriter<Entity> quartzTriggerWriter;
    private final ItemWriter<Entity> quartzSimpleTriggerWriter;
    private final ItemWriter<Entity> quartzCronTriggerWriter;

    @Override
    public void write(List<? extends Entity> items) throws Exception {
        try {
            this.quartzTriggerWriter.write(items);
            List simpleTriggers = items.stream().map(QuartzTriggerEntity.class::cast).filter(e -> e.getTriggerType().equals(QuartzTriggerType.SIMPLE.name())).collect(Collectors.toList());
            List cronTriggers = items.stream().map(QuartzTriggerEntity.class::cast).filter(e -> e.getTriggerType().equals(QuartzTriggerType.CRON.name())).collect(Collectors.toList());
            this.quartzSimpleTriggerWriter.write(simpleTriggers);
            this.quartzCronTriggerWriter.write(cronTriggers);
        }
        catch (DataIntegrityViolationException e2) {
            throw new WriteQuartzTriggerException(e2.getCause());
        }
    }

    @Generated
    public CompositeQuartzTriggerWriter(ItemWriter<Entity> quartzTriggerWriter, ItemWriter<Entity> quartzSimpleTriggerWriter, ItemWriter<Entity> quartzCronTriggerWriter) {
        this.quartzTriggerWriter = quartzTriggerWriter;
        this.quartzSimpleTriggerWriter = quartzSimpleTriggerWriter;
        this.quartzCronTriggerWriter = quartzCronTriggerWriter;
    }
}

