/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;

public class ShiroSessionScope
implements Scope {
    @Override
    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            @Override
            public T get() {
                Subject subject = ThreadContext.getSubject();
                if (subject == null) {
                    throw new OutOfScopeException("There is no Shiro Session currently in scope.");
                }
                Session session = subject.getSession();
                Object scoped = this.castSessionAttribute(session);
                if (scoped == null) {
                    scoped = unscoped.get();
                }
                return scoped;
            }

            private T castSessionAttribute(Session session) {
                return session.getAttribute((Object)key);
            }

            public String toString() {
                return unscoped.toString();
            }
        };
    }

    @Override
    public String toString() {
        return "ShiroSessionScope";
    }
}

