/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class PaddingPacket
extends ContainedPacket {
    private final byte[] padding;

    public PaddingPacket(BCPGInputStream bCPGInputStream) throws IOException {
        super(21);
        this.padding = Streams.readAll(bCPGInputStream);
    }

    public PaddingPacket(byte[] byArray) {
        super(21);
        this.padding = byArray;
    }

    public PaddingPacket(int n, SecureRandom secureRandom) {
        this(PaddingPacket.randomBytes(n, secureRandom));
    }

    private static byte[] randomBytes(int n, SecureRandom secureRandom) {
        byte[] byArray = new byte[n];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public byte[] getPadding() {
        return Arrays.clone(this.padding);
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(21, this.padding);
    }
}

