/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.util.Characters;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SExpression {
    private static final Set<Character> labelStop = new HashSet<Character>(){
        {
            this.add(Characters.valueOf(' '));
            this.add(Characters.valueOf(')'));
            this.add(Characters.valueOf('('));
            this.add(Characters.valueOf('#'));
            this.add(Characters.valueOf('\"'));
            this.add(Characters.valueOf(':'));
        }
    };
    private static final Set<String> stringLabels = new HashSet<String>(){
        {
            this.add("protected");
            this.add("protected-at");
            this.add("curve");
        }
    };
    private final ArrayList<Object> values = new ArrayList();
    private boolean canonical = false;
    private boolean parseCanonical = false;

    public SExpression(List<Object> list) {
        this.values.addAll(list);
    }

    public SExpression() {
    }

    public static SExpression parse(byte[] byArray, int n) throws IOException {
        return SExpression.parse(new ByteArrayInputStream(byArray), n);
    }

    public static SExpression parse(InputStream inputStream, int n) throws IOException {
        return SExpression.parseExpression(inputStream, null, new ByteArrayOutputStream(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SExpression parseExpression(InputStream inputStream, SExpression sExpression, ByteArrayOutputStream byteArrayOutputStream, int n) throws IOException {
        if (byteArrayOutputStream == null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
        }
        try {
            if (--n < 0) {
                throw new IllegalStateException("S-Expression exceeded maximum depth");
            }
            while (true) {
                int n2;
                if ((n2 = SExpression.consumeUntilSkipCRorLF(inputStream, byteArrayOutputStream, labelStop)) == 58) {
                    try {
                        int n3 = Integer.parseInt(Strings.fromByteArray(byteArrayOutputStream.toByteArray()));
                        byte[] byArray = new byte[n3];
                        Streams.readFully(inputStream, byArray);
                        if (sExpression.parseCanonical) {
                            int n4 = sExpression.values.size();
                            if (n4 > 0) {
                                Object object = sExpression.values.get(n4 - 1);
                                if (object instanceof String && stringLabels.contains(object)) {
                                    sExpression.addValue(Strings.fromUTF8ByteArray(byArray));
                                    continue;
                                }
                                sExpression.addValue(byArray);
                                continue;
                            }
                            sExpression.addValue(Strings.fromUTF8ByteArray(byArray));
                            continue;
                        }
                        sExpression.addValue(byArray);
                        sExpression.setCanonical(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        sExpression.addValue(byteArrayOutputStream.toByteArray());
                    }
                    continue;
                }
                if (byteArrayOutputStream.size() > 0) {
                    sExpression.addValue(Strings.fromByteArray(byteArrayOutputStream.toByteArray()));
                }
                if (n2 == 40) {
                    if (sExpression == null) {
                        sExpression = new SExpression();
                        SExpression.parseExpression(inputStream, sExpression, byteArrayOutputStream, n);
                        SExpression sExpression2 = sExpression;
                        return sExpression2;
                    }
                    SExpression sExpression3 = new SExpression();
                    sExpression3.parseCanonical = sExpression.parseCanonical;
                    sExpression.addValue(SExpression.parseExpression(inputStream, sExpression3, byteArrayOutputStream, n));
                    continue;
                }
                if (n2 == 35) {
                    SExpression.consumeUntilSkipWhiteSpace(inputStream, byteArrayOutputStream, '#');
                    sExpression.addValue(Hex.decode(Strings.fromByteArray(byteArrayOutputStream.toByteArray())));
                    continue;
                }
                if (n2 == 34) {
                    SExpression.consumeUntilSkipCRorLF(inputStream, byteArrayOutputStream, '\"');
                    sExpression.addValue(new QuotedString(Strings.fromByteArray(byteArrayOutputStream.toByteArray())));
                    continue;
                }
                if (n2 == 41) {
                    SExpression sExpression4 = sExpression;
                    return sExpression4;
                }
                if (n2 == -1) break;
            }
        }
        finally {
            ++n;
        }
        return sExpression;
    }

    static SExpression parseCanonical(InputStream inputStream, int n) throws IOException {
        SExpression sExpression = new SExpression();
        sExpression.parseCanonical = true;
        return SExpression.parseExpression(inputStream, sExpression, new ByteArrayOutputStream(), n).getExpression(0);
    }

    private static void consumeUntilSkipWhiteSpace(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, char c) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) > -1) {
            if (n <= 32) continue;
            if (n == c) {
                return;
            }
            byteArrayOutputStream.write(n);
        }
    }

    private static int consumeUntilSkipCRorLF(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, Set<Character> set) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        boolean bl = false;
        while ((n = inputStream.read()) > -1) {
            if (bl && n <= 32) {
                bl = false;
                continue;
            }
            if (n == 10) {
                bl = true;
                continue;
            }
            if (set.contains(Characters.valueOf((char)n))) {
                return n;
            }
            byteArrayOutputStream.write(n);
        }
        return -1;
    }

    private static int consumeUntilSkipCRorLF(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, char c) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        boolean bl = false;
        while ((n = inputStream.read()) > -1) {
            if (bl && n <= 32) {
                bl = false;
                continue;
            }
            if (n == 10) {
                bl = true;
                continue;
            }
            if (c == n) {
                return n;
            }
            byteArrayOutputStream.write(n);
        }
        return -1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addValue(Object object) {
        this.values.add(object);
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    public String getString(int n) {
        Object object = this.values.get(n);
        if (object instanceof byte[]) {
            return Strings.fromUTF8ByteArray((byte[])object);
        }
        return this.values.get(n).toString();
    }

    public int getInt(int n) {
        return Integer.parseInt(this.getString(n));
    }

    public byte[] getBytes(int n) {
        return (byte[])this.values.get(n);
    }

    public SExpression getExpression(int n) {
        return (SExpression)this.values.get(n);
    }

    public List<Object> getValues() {
        return this.values;
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    private void setCanonical(boolean bl) {
        this.canonical = bl;
    }

    public PGPExtendedKeyAttribute toAttribute() {
        PGPExtendedKeyAttribute.Builder builder = PGPExtendedKeyAttribute.builder();
        Iterator<Object> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            builder.addAttribute(iterator.next());
        }
        return builder.build();
    }

    public SExpression filterOut(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        SExpression sExpression = new SExpression();
        for (Object object : this.values) {
            if (hashSet.contains(object.toString())) continue;
            if (object instanceof SExpression) {
                String string;
                if (!((SExpression)object).values.isEmpty() && hashSet.contains(string = ((SExpression)object).values.get(0).toString())) continue;
                sExpression.values.add(((SExpression)object).filterOut(stringArray));
                continue;
            }
            sExpression.values.add(object);
        }
        return sExpression;
    }

    static SExpression buildExpression(SExpression sExpression, String[] stringArray) {
        SExpression sExpression2 = new SExpression();
        sExpression2.addValue(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            SExpression sExpression3 = sExpression.getExpressionWithLabel(stringArray[i]);
            if (sExpression3 == null) continue;
            sExpression2.values.add(sExpression3);
        }
        return sExpression2;
    }

    static SExpression buildExpression(SExpression sExpression, SExpression sExpression2, String[] stringArray) {
        SExpression sExpression3 = new SExpression();
        sExpression3.addValue(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            SExpression sExpression4 = sExpression.getExpressionWithLabel(stringArray[i]);
            if (sExpression4 != null) {
                sExpression3.values.add(sExpression4);
                continue;
            }
            sExpression4 = sExpression2.getExpressionWithLabel(stringArray[i]);
            if (sExpression4 == null) continue;
            sExpression3.values.add(sExpression4);
        }
        return sExpression3;
    }

    public SExpression filterIn(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        SExpression sExpression = new SExpression();
        for (Object object : this.values) {
            if (object instanceof SExpression) {
                String string;
                if (!((SExpression)object).values.isEmpty() && !hashSet.contains(string = ((SExpression)object).values.get(0).toString())) continue;
                sExpression.values.add(object);
                continue;
            }
            if (!hashSet.contains(object.toString())) continue;
            sExpression.values.add(object);
        }
        return sExpression;
    }

    public byte[] toCanonicalForm() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.toCanonicalForm(byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new PGPRuntimeOperationException(exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void toCanonicalForm(OutputStream outputStream) throws IOException {
        outputStream.write(40);
        for (Object object : this.values) {
            Object object2;
            if (object instanceof QuotedString) {
                object2 = ((QuotedString)object).value;
                outputStream.write(Strings.toByteArray(Integer.toString(((String)object2).length())));
                outputStream.write(58);
                outputStream.write(Strings.toUTF8ByteArray((String)object2));
                continue;
            }
            if (object instanceof String) {
                object2 = (String)object;
                outputStream.write(Strings.toByteArray(Integer.toString(((String)object2).length())));
                outputStream.write(58);
                outputStream.write(Strings.toUTF8ByteArray((String)object2));
                continue;
            }
            if (object instanceof byte[]) {
                object2 = (byte[])object;
                outputStream.write(Strings.toByteArray(Integer.toString(((Object)object2).length)));
                outputStream.write(58);
                outputStream.write((byte[])object2);
                continue;
            }
            if (object instanceof SExpression) {
                ((SExpression)object).toCanonicalForm(outputStream);
                continue;
            }
            throw new IllegalStateException("unhandled type " + object.getClass().getName() + " in value list");
        }
        outputStream.write(41);
        outputStream.flush();
    }

    public boolean hasLabel(String string) {
        if (this.values.isEmpty()) {
            throw new IllegalArgumentException("S-Expression is empty");
        }
        Object object = this.values.get(0);
        object = object instanceof String || object instanceof QuotedString ? object.toString() : Strings.fromByteArray((byte[])object);
        return object.equals(string);
    }

    public SExpression getExpressionWithLabel(String string) {
        for (Object object : this.values) {
            if (!(object instanceof SExpression) || !((SExpression)object).hasLabel(string)) continue;
            return (SExpression)object;
        }
        return null;
    }

    public SExpression getExpressionWithLabelOrFail(String string) {
        for (Object object : this.values) {
            if (!(object instanceof SExpression) || !((SExpression)object).hasLabel(string)) continue;
            return (SExpression)object;
        }
        throw new IllegalArgumentException("label " + string + " was not found");
    }

    public static class Builder {
        List<Object> values = new ArrayList<Object>();

        public Builder addValue(Object object) {
            this.values.add(object);
            return this;
        }

        public SExpression build() {
            return new SExpression(this.values);
        }

        public Builder addContent(SExpression sExpression) {
            Iterator iterator = sExpression.values.iterator();
            while (iterator.hasNext()) {
                this.values.add(iterator.next());
            }
            return this;
        }
    }

    public static class QuotedString {
        private final String value;

        public QuotedString(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

