/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Iso8601Date {
    public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    private Iso8601Date() {
    }

    private static DateFormat getFormat() {
        return new SimpleDateFormat(PATTERN);
    }

    public static Date parse(String value) throws ParseException {
        Preconditions.checkNotNull(value);
        return Iso8601Date.getFormat().parse(value);
    }

    public static String format(Date date) {
        Preconditions.checkNotNull(date);
        return Iso8601Date.getFormat().format(date);
    }
}

