/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.i18n;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.i18n.MessageSource;
import org.sonatype.goodies.i18n.ResourceNotFoundException;

public class AggregateMessageSource
extends ComponentSupport
implements MessageSource {
    private final List<MessageSource> sources = Lists.newArrayList();

    public AggregateMessageSource(List<MessageSource> sources) {
        Preconditions.checkNotNull(sources);
        this.sources.addAll(sources);
    }

    public AggregateMessageSource(MessageSource ... sources) {
        this(Arrays.asList(sources));
    }

    public List<MessageSource> getSources() {
        return this.sources;
    }

    @Override
    public String getMessage(String code) {
        String result = null;
        for (MessageSource source : this.sources) {
            try {
                result = source.getMessage(code);
                if (result == null) continue;
                break;
            }
            catch (ResourceNotFoundException e) {
                this.log.trace(e.toString(), e);
            }
        }
        if (result == null) {
            throw new ResourceNotFoundException(code);
        }
        return result;
    }

    @Override
    public String getMessage(String code, String defaultValue) {
        try {
            return this.getMessage(code);
        }
        catch (ResourceNotFoundException e) {
            return defaultValue;
        }
    }

    @Override
    public String format(String code, Object ... args) {
        String result = null;
        for (MessageSource source : this.sources) {
            try {
                result = source.format(code, args);
                if (result == null) continue;
                break;
            }
            catch (ResourceNotFoundException e) {
                this.log.trace(e.toString(), e);
            }
        }
        if (result == null) {
            throw new ResourceNotFoundException(code);
        }
        return result;
    }
}

