/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import java.io.Serializable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.sonatype.gossip.Level;

public final class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean traceEnable = Boolean.getBoolean(Event.class.getName() + ".traceEnable");
    private final Logger logger;
    private final Level level;
    private final String message;
    private final Throwable cause;
    private final long timeStamp;
    private final String threadName;
    private final StackTraceElement[] trace;

    public Event(Logger logger, Level level, String message, Throwable cause) {
        this.logger = logger;
        this.level = level;
        this.message = message;
        this.cause = cause;
        this.timeStamp = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
        this.trace = traceEnable ? new Throwable().getStackTrace() : null;
    }

    public String getName() {
        return this.logger.getName();
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public StackTraceElement[] getTrace() {
        return this.trace;
    }

    public String toString() {
        return "Event{logger=" + this.logger + ", level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + ", cause=" + this.cause + ", timeStamp=" + this.timeStamp + ", threadName='" + this.threadName + '\'' + ", trace=" + (this.trace == null ? null : Arrays.asList(this.trace)) + '}';
    }
}

