/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;

public final class LoggerDelegateFactory {
    public static Logger create(Logger target) {
        return (Logger)Proxy.newProxyInstance(target.getClass().getClassLoader(), new Class[]{Logger.class, LoggerDelegateAware.class}, (InvocationHandler)new DelegateHandler(target));
    }

    private static class DelegateHandler
    implements InvocationHandler,
    LoggerDelegateAware {
        private Logger delegate;

        private DelegateHandler(Logger delegate) {
            this.setDelegate(delegate);
        }

        public Logger getDelegate() {
            return this.delegate;
        }

        public void setDelegate(Logger delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == LoggerDelegateAware.class) {
                return method.invoke((Object)this, args);
            }
            return method.invoke((Object)this.getDelegate(), args);
        }
    }

    public static interface LoggerDelegateAware {
        public Logger getDelegate();

        public void setDelegate(Logger var1);
    }
}

