/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cache;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cache.CacheBuilder;

@Named
@Singleton
public class CacheHelper
extends ComponentSupport {
    private final Provider<CacheManager> cacheManagerProvider;
    private final Provider<CacheBuilder> cacheBuilderProvider;

    @Inject
    public CacheHelper(Provider<CacheManager> cacheManagerProvider, Provider<CacheBuilder> cacheBuilderProvider) {
        this.cacheManagerProvider = Preconditions.checkNotNull(cacheManagerProvider);
        this.cacheBuilderProvider = Preconditions.checkNotNull(cacheBuilderProvider);
    }

    private CacheManager manager() {
        return this.cacheManagerProvider.get();
    }

    public <K, V> CacheBuilder<K, V> builder() {
        return this.cacheBuilderProvider.get();
    }

    public synchronized <K, V> Cache<K, V> maybeCreateCache(String name, MutableConfiguration<K, V> mutableConfiguration) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(mutableConfiguration);
        Cache<K, V> cache = this.manager().getCache(name, mutableConfiguration.getKeyType(), mutableConfiguration.getValueType());
        if (cache == null) {
            cache = this.manager().createCache(name, mutableConfiguration);
            this.log.debug("Created cache: {}", (Object)cache);
        } else {
            this.log.debug("Re-using existing cache: {}", (Object)cache);
        }
        return cache;
    }

    public synchronized <K, V> Cache<K, V> getOrCreate(CacheBuilder<K, V> builder) {
        Preconditions.checkNotNull(builder);
        Cache<K, V> cache = this.manager().getCache(builder.getName(), builder.getKeyType(), builder.getValueType());
        if (cache == null) {
            cache = builder.build(this.manager());
            this.log.debug("Created cache: {}", (Object)cache);
        } else {
            this.log.debug("Re-using existing cache: {}", (Object)cache);
        }
        return cache;
    }

    public synchronized <K, V> Cache<K, V> maybeCreateCache(String name, Factory<? extends ExpiryPolicy> expiryPolicyFactory) {
        return this.maybeCreateCache(name, null, null, expiryPolicyFactory);
    }

    public synchronized <K, V> Cache<K, V> maybeCreateCache(String name, @Nullable Class<K> keyType, @Nullable Class<V> valueType, Factory<? extends ExpiryPolicy> expiryPolicyFactory) {
        return this.maybeCreateCache(name, CacheHelper.createCacheConfig(keyType, valueType, expiryPolicyFactory));
    }

    public static <K, V> MutableConfiguration<K, V> createCacheConfig(@Nullable Class<K> keyType, @Nullable Class<V> valueType, Factory<? extends ExpiryPolicy> expiryPolicyFactory) {
        MutableConfiguration<K, V> config = new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(expiryPolicyFactory).setManagementEnabled(true).setStatisticsEnabled(true);
        if (keyType != null && valueType != null) {
            config.setTypes(keyType, valueType);
        }
        return config;
    }

    public synchronized void maybeDestroyCache(String name) {
        this.manager().destroyCache(name);
        this.log.debug("Destroyed cache: {}", (Object)name);
    }
}

