/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.app;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.sonatype.nexus.common.app.FreezeRequest;

public interface FreezeService {
    public void requestFreeze(String var1);

    public void cancelFreeze();

    public void taskRequestFreeze(String var1, String var2);

    public void taskCancelFreeze(String var1);

    public List<FreezeRequest> cancelAllFreezeRequests();

    default public void freezeDuring(String reason, Runnable operation) {
        String token = UUID.randomUUID() + "@" + operation.hashCode();
        this.taskRequestFreeze(token, reason);
        try {
            operation.run();
        }
        finally {
            this.taskCancelFreeze(token);
        }
    }

    default public <T> T freezeDuring(String reason, Supplier<T> operation) {
        String token = UUID.randomUUID() + "@" + operation.hashCode();
        this.taskRequestFreeze(token, reason);
        try {
            T t2 = operation.get();
            return t2;
        }
        finally {
            this.taskCancelFreeze(token);
        }
    }

    public boolean isFrozen();

    default public boolean isFrozenByUser() {
        return this.currentFreezeRequests().stream().anyMatch(FreezeRequest::isUserRequest);
    }

    public List<FreezeRequest> currentFreezeRequests();

    public void checkReadable(String var1);

    public void checkWritable(String var1);
}

