/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.app;

import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;

public abstract class ManagedLifecycleManager
extends ComponentSupport {
    private static volatile boolean shuttingDown;

    public abstract ManagedLifecycle.Phase getCurrentPhase();

    public abstract void to(ManagedLifecycle.Phase var1) throws Exception;

    public abstract void bounce(ManagedLifecycle.Phase var1) throws Exception;

    public static boolean isShuttingDown() {
        return shuttingDown;
    }

    protected ManagedLifecycleManager() {
        shuttingDown = false;
    }

    protected void declareShutdown() {
        this.log.info("Shutting down");
        shuttingDown = true;
    }

    public void shutdownWithExitCode(int exitCode) throws Exception {
        System.setProperty("nexus.overrideExitCode", Integer.toString(exitCode));
        this.log.info("Shutdown requested with an exit code of " + exitCode);
        this.to(ManagedLifecycle.Phase.OFF);
    }
}

