/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;

public class ImmutableNestedAttributesMap
extends NestedAttributesMap {
    public ImmutableNestedAttributesMap(@Nullable NestedAttributesMap parent, String key, Map<String, Object> backing) {
        super(parent, key, Collections.unmodifiableMap(backing));
    }

    @Override
    public NestedAttributesMap child(String name) {
        Preconditions.checkNotNull(name);
        Object child = this.backing.get(name);
        if (child == null) {
            child = ImmutableMap.of();
        } else {
            Preconditions.checkState(child instanceof Map, "child '%s' not a Map", (Object)name);
        }
        return new ImmutableNestedAttributesMap(this, name, (Map)child);
    }
}

