/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class StringMultimap
implements Iterable<Map.Entry<String, String>> {
    private final ListMultimap<String, String> backing;

    public StringMultimap(ListMultimap<String, String> entries) {
        this.backing = Preconditions.checkNotNull(entries);
    }

    public StringMultimap() {
        this(ArrayListMultimap.create());
    }

    public boolean contains(String name) {
        return this.backing.containsKey(name);
    }

    public List<String> getAll(String name) {
        return this.backing.get((Object)name);
    }

    @Nullable
    public String get(String name) {
        Collection values = this.backing.get((Object)name);
        if (!values.isEmpty()) {
            return (String)values.get(0);
        }
        return null;
    }

    public void set(String name, String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.backing.put(name, value);
            ++n2;
        }
    }

    public void replace(String name, String ... values) {
        this.backing.replaceValues((Object)name, Arrays.asList(values));
    }

    public void set(String name, Iterable<String> values) {
        this.backing.putAll(name, values);
    }

    public void remove(String name) {
        this.backing.removeAll(name);
    }

    public void clear() {
        this.backing.clear();
    }

    public Set<String> names() {
        return this.backing.keySet();
    }

    public int size() {
        return this.backing.keySet().size();
    }

    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    public Collection<Map.Entry<String, String>> entries() {
        return this.backing.entries();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.backing.entries().iterator();
    }

    public String toString() {
        return this.backing.toString();
    }
}

