/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.cooperation2.internal.orient;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.IOCall;
import org.sonatype.nexus.common.cooperation2.internal.Cooperation2Builder;
import org.sonatype.nexus.common.io.Cooperation;

public class OrientCooperation2
extends ComponentSupport
implements Cooperation2 {
    private Cooperation cooperation;

    public OrientCooperation2(Cooperation cooperation) {
        this.cooperation = Preconditions.checkNotNull(cooperation);
    }

    @Override
    public <RET> Cooperation2.Builder<RET> on(IOCall<RET> workFunction) {
        return new OrientCooperation2Builder<RET>(workFunction);
    }

    @Override
    public Map<String, Integer> getThreadCountPerKey() {
        return this.cooperation.getThreadCountPerKey();
    }

    protected class OrientCooperation2Builder<RET>
    extends Cooperation2Builder<RET> {
        protected OrientCooperation2Builder(IOCall<RET> workFunction) {
            super(workFunction);
        }

        @Override
        public RET cooperate(String action, String ... scopes) throws IOException {
            StringJoiner joiner = new StringJoiner(":");
            joiner.add(action);
            Arrays.asList(scopes).forEach(joiner::add);
            return (RET)OrientCooperation2.this.cooperation.cooperate(joiner.toString(), (boolean failover) -> {
                if (failover) {
                    Optional cachedValue = OrientCooperation2.this.cooperation.join(this.checkFunction::check);
                    if (cachedValue.isPresent()) {
                        return cachedValue.get();
                    }
                }
                return this.workFunction.call();
            });
        }
    }
}

