/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.decorator;

import javax.annotation.Nullable;
import org.sonatype.nexus.common.decorator.DecoratedObject;

public class DecoratorUtils {
    private DecoratorUtils() {
    }

    @Nullable
    public static <T> T getDecoratedEntity(Object decoratedObject, Class<T> clazz) {
        if (clazz.isAssignableFrom(decoratedObject.getClass())) {
            return (T)decoratedObject;
        }
        if (!(decoratedObject instanceof DecoratedObject)) {
            return null;
        }
        Object wrappedObject = ((DecoratedObject)decoratedObject).getWrappedObject();
        if (clazz.isAssignableFrom(wrappedObject.getClass())) {
            return wrappedObject;
        }
        if (wrappedObject instanceof DecoratedObject) {
            return DecoratorUtils.getDecoratedEntity(wrappedObject, clazz);
        }
        return null;
    }
}

