/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.sonatype.nexus.common.entity.EntityId;

public class EntityUUID
implements EntityId {
    @JsonProperty(value="value")
    private final UUID id;

    public EntityUUID() {
        this.id = UUID.randomUUID();
    }

    public EntityUUID(UUID id) {
        this.id = Preconditions.checkNotNull(id);
    }

    public UUID uuid() {
        return this.id;
    }

    @Override
    public String getValue() {
        return this.id.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EntityUUID) {
            return this.id.equals(((EntityUUID)o).id);
        }
        if (o instanceof EntityId) {
            return this.getValue().equals(((EntityId)o).getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "id='" + this.id + '\'' + '}';
    }
}

