/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.event;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;

public class EventHelper {
    private static final ThreadLocal<Boolean> isReplicating = new ThreadLocal();

    private EventHelper() {
    }

    public static boolean isReplicating() {
        return Boolean.TRUE.equals(isReplicating.get());
    }

    public static <T> T asReplicating(Supplier<T> supplier) {
        Preconditions.checkState(!EventHelper.isReplicating(), "Replication already in progress");
        isReplicating.set(Boolean.TRUE);
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            isReplicating.remove();
        }
    }

    public static void asReplicating(Runnable runnable) {
        Preconditions.checkState(!EventHelper.isReplicating(), "Replication already in progress");
        isReplicating.set(Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            isReplicating.remove();
        }
    }
}

