/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.hash.HashAlgorithm;

@Deprecated
@Named
@Singleton
public class HashAlgorithmHelper {
    private final int bufferSize;

    @Inject
    public HashAlgorithmHelper(@Named(value="${nexus.calculateChecksums.bufferSize:-32768}") @Named(value="${nexus.calculateChecksums.bufferSize:-32768}") int bufferSize) {
        Preconditions.checkState(bufferSize > 0, String.format("Buffer size should be a positive value: %s", bufferSize));
        this.bufferSize = bufferSize;
    }

    public Map<HashAlgorithm, HashCode> calculateChecksums(File content, Iterable<HashAlgorithm> hashAlgorithms) throws IOException {
        Preconditions.checkNotNull(content);
        Preconditions.checkNotNull(hashAlgorithms);
        HashMap<HashAlgorithm, MessageDigest> hashAlgorithmMessageDigestMap = new HashMap<HashAlgorithm, MessageDigest>();
        for (HashAlgorithm hashAlgorithm : hashAlgorithms) {
            MessageDigest messageDigest = this.getInstance(hashAlgorithm.name());
            hashAlgorithmMessageDigestMap.put(hashAlgorithm, messageDigest);
        }
        return this.calculateChecksumsBuffered(content, hashAlgorithmMessageDigestMap, this.bufferSize);
    }

    private Map<HashAlgorithm, HashCode> calculateChecksumsBuffered(File content, Map<HashAlgorithm, MessageDigest> hashAlgorithmMessageDigestMap, int bufferSize) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream inputStream = new FileInputStream(content);){
            int n = 0;
            byte[] buffer = new byte[bufferSize];
            while (n != -1) {
                n = ((InputStream)inputStream).read(buffer);
                if (n <= 0) continue;
                for (MessageDigest messageDigest : hashAlgorithmMessageDigestMap.values()) {
                    messageDigest.update(buffer, 0, n);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return hashAlgorithmMessageDigestMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> HashCode.fromBytes(((MessageDigest)x.getValue()).digest()), (x, y) -> x, LinkedHashMap::new));
    }

    private MessageDigest getInstance(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

