/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import java.time.Duration;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;

public abstract class CooperationFactorySupport
extends LifecycleSupport
implements CooperationFactory {
    @Override
    public CooperationFactory.Builder configure() {
        return new MutableConfig();
    }

    protected abstract Cooperation build(String var1, Config var2);

    public static class Config {
        protected int majorTimeoutSeconds = 0;
        protected int minorTimeoutSeconds = 0;
        protected int threadsPerKey = 0;

        public Duration majorTimeout() {
            return Duration.ofSeconds(this.majorTimeoutSeconds);
        }

        public Duration minorTimeout() {
            return Duration.ofSeconds(this.minorTimeoutSeconds);
        }

        public int threadsPerKey() {
            return this.threadsPerKey;
        }

        protected Config copy() {
            Config copy = new Config();
            copy.majorTimeoutSeconds = this.majorTimeoutSeconds;
            copy.minorTimeoutSeconds = this.minorTimeoutSeconds;
            copy.threadsPerKey = this.threadsPerKey;
            return copy;
        }
    }

    private final class MutableConfig
    extends Config
    implements CooperationFactory.Builder {
        private MutableConfig() {
        }

        @Override
        public CooperationFactory.Builder majorTimeout(Duration majorTimeout) {
            this.majorTimeoutSeconds = (int)majorTimeout.getSeconds();
            return this;
        }

        @Override
        public CooperationFactory.Builder minorTimeout(Duration minorTimeout) {
            this.minorTimeoutSeconds = (int)minorTimeout.getSeconds();
            return this;
        }

        @Override
        public CooperationFactory.Builder threadsPerKey(int threadsPerKey) {
            this.threadsPerKey = threadsPerKey;
            return this;
        }

        @Override
        public Cooperation build(String id) {
            return CooperationFactorySupport.this.build(id, this.copy());
        }
    }
}

