/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FileFinder {
    public static Optional<Path> findLatestTimestampedFile(Path directoryPath, String prefix, String suffix) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> stream = Files.list(directoryPath);){
            Predicate<Path> nameCheck = path -> FileFinder.matchesPattern(path, prefix, suffix);
            Comparator<Path> timestampComparator = Comparator.comparingLong(path -> FileFinder.getFileTimestamp(path, prefix, suffix));
            return stream.filter(nameCheck).max(timestampComparator);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean matchesPattern(Path path, String prefix, String suffix) {
        String fileName = path.getFileName().toString();
        return fileName.startsWith(prefix) && fileName.endsWith(suffix);
    }

    private static long getFileTimestamp(Path path, String prefix, String suffix) {
        String fileName = path.getFileName().toString();
        String timestampStr = fileName.substring(prefix.length(), fileName.length() - suffix.length());
        return Long.parseLong(timestampStr.replace("-", ""));
    }
}

