/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.text;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;

public final class Strings2 {
    public static final String NL = System.lineSeparator();
    public static final String MASK = "****";

    private Strings2() {
    }

    public static boolean isEmpty(@Nullable String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isBlank(@Nullable String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean notBlank(@Nullable String value) {
        return !Strings2.isBlank(value);
    }

    @Nullable
    public static String mask(@Nullable String password) {
        if (password != null) {
            return MASK;
        }
        return null;
    }

    public static String lower(String value) {
        Preconditions.checkNotNull(value);
        return value.toLowerCase(Locale.ENGLISH);
    }

    public static String upper(String value) {
        Preconditions.checkNotNull(value);
        return value.toUpperCase(Locale.ENGLISH);
    }

    public static String utf8(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] utf8(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String encodeSeparator(String input, char separator, int delay) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (i != 0 && i % delay == 0) {
                buff.append(separator);
            }
            buff.append(c);
            ++i;
            ++n2;
        }
        return buff.toString();
    }

    public static String decodeBase64(String value) {
        return Strings2.utf8(BaseEncoding.base64().decode(value));
    }

    public static String encodeBase64(String value) {
        return BaseEncoding.base64().encode(Strings2.utf8(value));
    }

    public static String capitalize(String value) {
        if (value == null || value.length() < 1) {
            return value;
        }
        return String.valueOf(Character.toTitleCase(value.charAt(0))) + value.substring(1);
    }
}

