/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.crypto.internal;

import com.google.common.base.Preconditions;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.crypto.CryptoHelper;

@Named
@Singleton
public class CryptoHelperImpl
extends ComponentSupport
implements CryptoHelper {
    private final Provider provider = CryptoHelperImpl.configureProvider();

    public static Provider configureProvider() {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
        }
        return provider;
    }

    public Provider getProvider() {
        return this.provider;
    }

    private void logFallback(Throwable cause) {
        this.log.trace("Falling back to system selection due to: " + cause);
    }

    @Override
    public Cipher createCipher(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher obj;
        Preconditions.checkNotNull(transformation);
        try {
            obj = Cipher.getInstance(transformation, this.getProvider());
        }
        catch (Exception e) {
            this.logFallback(e);
            obj = Cipher.getInstance(transformation);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created cipher: {} ({})", (Object)obj.getAlgorithm(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public int getCipherMaxAllowedKeyLength(String transformation) throws NoSuchAlgorithmException {
        return Cipher.getMaxAllowedKeyLength(transformation);
    }

    @Override
    public Signature createSignature(String algorithm) throws NoSuchAlgorithmException {
        Signature obj;
        Preconditions.checkNotNull(algorithm);
        try {
            obj = Signature.getInstance(algorithm, this.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            this.logFallback(e);
            obj = Signature.getInstance(algorithm);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created signature: {} ({})", (Object)obj.getAlgorithm(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public SecureRandom createSecureRandom(String algorithm) throws NoSuchAlgorithmException {
        SecureRandom obj;
        Preconditions.checkNotNull(algorithm);
        try {
            obj = SecureRandom.getInstance(algorithm, this.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            this.logFallback(e);
            obj = SecureRandom.getInstance(algorithm);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created secure-random: {} ({})", (Object)obj.getAlgorithm(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public SecureRandom createSecureRandom() {
        SecureRandom obj = new SecureRandom();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created secure-random: {} ({})", (Object)obj.getAlgorithm(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public KeyStore createKeyStore(String type) throws KeyStoreException {
        KeyStore obj;
        Preconditions.checkNotNull(type);
        try {
            obj = KeyStore.getInstance(type, this.getProvider());
        }
        catch (KeyStoreException e) {
            this.logFallback(e);
            obj = KeyStore.getInstance(type);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created key-store: {} ({})", (Object)obj.getType(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public KeyPairGenerator createKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator obj;
        Preconditions.checkNotNull(algorithm);
        try {
            obj = KeyPairGenerator.getInstance(algorithm, this.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            this.logFallback(e);
            obj = KeyPairGenerator.getInstance(algorithm);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created key-pair-generator: {} ({})", (Object)obj.getAlgorithm(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public CertificateFactory createCertificateFactory(String type) throws CertificateException {
        CertificateFactory obj;
        Preconditions.checkNotNull(type);
        try {
            obj = CertificateFactory.getInstance(type, this.getProvider());
        }
        catch (CertificateException e) {
            this.logFallback(e);
            obj = CertificateFactory.getInstance(type);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created certificate-factory: {} ({})", (Object)obj.getType(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public KeyManagerFactory createKeyManagerFactory(String algorithm) throws NoSuchAlgorithmException {
        KeyManagerFactory obj;
        Preconditions.checkNotNull(algorithm);
        try {
            obj = KeyManagerFactory.getInstance(algorithm, this.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            this.logFallback(e);
            obj = KeyManagerFactory.getInstance(algorithm);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created key-manager-factory: {} ({})", (Object)obj.getAlgorithm(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public TrustManagerFactory createTrustManagerFactory(String algorithm) throws NoSuchAlgorithmException {
        TrustManagerFactory obj;
        Preconditions.checkNotNull(algorithm);
        try {
            obj = TrustManagerFactory.getInstance(algorithm, this.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            this.logFallback(e);
            obj = TrustManagerFactory.getInstance(algorithm);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created trust-manager-factory: {} ({})", (Object)obj.getAlgorithm(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public MessageDigest createDigest(String algorithm) throws NoSuchAlgorithmException {
        MessageDigest obj;
        Preconditions.checkNotNull(algorithm);
        try {
            obj = MessageDigest.getInstance(algorithm, this.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            this.logFallback(e);
            obj = MessageDigest.getInstance(algorithm);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created message-digest: {} ({})", (Object)obj.getAlgorithm(), (Object)obj.getProvider().getName());
        }
        return obj;
    }

    @Override
    public SecretKeyFactory createSecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        SecretKeyFactory obj;
        Preconditions.checkNotNull(algorithm);
        try {
            obj = SecretKeyFactory.getInstance(algorithm, this.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            this.logFallback(e);
            obj = SecretKeyFactory.getInstance(algorithm);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created secret-key-factory: {} ({})", (Object)obj.getAlgorithm(), (Object)obj.getProvider().getName());
        }
        return obj;
    }
}

