/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.crypto.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.sonatype.nexus.crypto.CryptoHelper;

@ThreadSafe
public class PasswordCipher {
    private static final int SPICE_SIZE = 16;
    private static final int SALT_SIZE = 8;
    private static final int CHUNK_SIZE = 16;
    private static final String DIGEST_ALG = "SHA-256";
    private static final String KEY_ALG = "AES";
    private static final String CIPHER_ALG = "AES/CBC/PKCS5Padding";
    private final CryptoHelper cryptoHelper;
    private final Base64Encoder base64Encoder;
    private final SecureRandom secureRandom;

    public PasswordCipher(CryptoHelper cryptoHelper) {
        this.cryptoHelper = Preconditions.checkNotNull(cryptoHelper);
        this.base64Encoder = new Base64Encoder();
        this.secureRandom = cryptoHelper.createSecureRandom();
        this.secureRandom.setSeed(System.nanoTime());
    }

    public byte[] encrypt(byte[] payload, String passPhrase) {
        Preconditions.checkNotNull(payload);
        Preconditions.checkNotNull(passPhrase);
        try {
            byte[] salt = new byte[8];
            this.secureRandom.nextBytes(salt);
            Cipher cipher = this.createCipher(passPhrase, salt, 1);
            byte[] encryptedBytes = cipher.doFinal(payload);
            int len = encryptedBytes.length;
            byte padLen = (byte)(16 - (8 + len + 1) % 16);
            int totalLen = 8 + len + padLen + 1;
            byte[] allEncryptedBytes = new byte[totalLen];
            this.secureRandom.nextBytes(allEncryptedBytes);
            System.arraycopy(salt, 0, allEncryptedBytes, 0, 8);
            allEncryptedBytes[8] = padLen;
            System.arraycopy(encryptedBytes, 0, allEncryptedBytes, 9, len);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(allEncryptedBytes.length * 2);
            this.base64Encoder.encode(allEncryptedBytes, 0, allEncryptedBytes.length, bout);
            return bout.toByteArray();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public byte[] decrypt(byte[] payload, String passPhrase) {
        Preconditions.checkNotNull(payload);
        Preconditions.checkNotNull(passPhrase);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.base64Encoder.decode(payload, 0, payload.length, baos);
            byte[] allEncryptedBytes = baos.toByteArray();
            int totalLen = allEncryptedBytes.length;
            byte[] salt = new byte[8];
            System.arraycopy(allEncryptedBytes, 0, salt, 0, 8);
            byte padLen = allEncryptedBytes[8];
            byte[] encryptedBytes = new byte[totalLen - 8 - 1 - padLen];
            System.arraycopy(allEncryptedBytes, 9, encryptedBytes, 0, encryptedBytes.length);
            Cipher cipher = this.createCipher(passPhrase, salt, 2);
            return cipher.doFinal(encryptedBytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid payload (base64 problem)", e);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    private Cipher createCipher(String passPhrase, byte[] salt, int mode) throws Exception {
        MessageDigest digester = this.cryptoHelper.createDigest(DIGEST_ALG);
        byte[] keyAndIv = new byte[32];
        if (salt == null || salt.length == 0) {
            salt = null;
        }
        int currentPos = 0;
        while (currentPos < keyAndIv.length) {
            int stillNeed;
            byte[] result;
            digester.update(passPhrase.getBytes(StandardCharsets.UTF_8));
            if (salt != null) {
                digester.update(salt, 0, 8);
            }
            if ((result = digester.digest()).length > (stillNeed = keyAndIv.length - currentPos)) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result, 0, b, 0, b.length);
                result = b;
            }
            System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
            if ((currentPos += result.length) >= keyAndIv.length) continue;
            digester.reset();
            digester.update(result);
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(keyAndIv, 0, key, 0, key.length);
        System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
        Cipher cipher = Cipher.getInstance(CIPHER_ALG);
        cipher.init(mode, (Key)new SecretKeySpec(key, KEY_ALG), new IvParameterSpec(iv));
        return cipher;
    }
}

