/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.crypto.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.crypto.PbeCipherFactory;

@Named
@Singleton
public class PbeCipherFactoryImpl
extends ComponentSupport
implements PbeCipherFactory {
    private final CryptoHelper cryptoHelper;

    @Inject
    public PbeCipherFactoryImpl(CryptoHelper cryptoHelper) {
        this.cryptoHelper = Preconditions.checkNotNull(cryptoHelper);
    }

    @Override
    public PbeCipherFactory.PbeCipher create(String password, String salt, String iv) throws Exception {
        Preconditions.checkNotNull(password);
        Preconditions.checkNotNull(salt);
        Preconditions.checkNotNull(iv);
        return new PbeCipherImpl(this.cryptoHelper, password, salt, iv);
    }

    private static class PbeCipherImpl
    implements PbeCipherFactory.PbeCipher {
        private final CryptoHelper cryptoHelper;
        private final AlgorithmParameterSpec paramSpec;
        private final SecretKey secretKey;

        public PbeCipherImpl(CryptoHelper cryptoHelper, String password, String salt, String iv) throws Exception {
            this.cryptoHelper = cryptoHelper;
            this.paramSpec = new IvParameterSpec(iv.getBytes());
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 1024, 128);
            SecretKeyFactory factory = cryptoHelper.createSecretKeyFactory("PBKDF2WithHmacSHA1");
            SecretKey tmp = factory.generateSecret(spec);
            this.secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        }

        @Override
        public byte[] encrypt(byte[] bytes) {
            return this.transform(1, bytes);
        }

        @Override
        public byte[] decrypt(byte[] bytes) {
            return this.transform(2, bytes);
        }

        private byte[] transform(int mode, byte[] bytes) {
            try {
                Cipher cipher = this.cryptoHelper.createCipher("AES/CBC/PKCS5Padding");
                cipher.init(mode, (Key)this.secretKey, this.paramSpec);
                return cipher.doFinal(bytes, 0, bytes.length);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
    }
}

