/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jmx.reflect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.management.Descriptor;
import javax.management.DescriptorKey;
import javax.management.ImmutableDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorHelper {
    private static final Logger log = LoggerFactory.getLogger(DescriptorHelper.class);

    public static Descriptor build(Class<?> type) {
        Preconditions.checkNotNull(type);
        log.trace("Building descriptor for type: {}", (Object)type);
        return DescriptorHelper.build(type.getAnnotations());
    }

    public static Descriptor build(Method method) {
        Preconditions.checkNotNull(method);
        log.trace("Building descriptor for method: {}", (Object)method);
        return DescriptorHelper.build(method.getAnnotations());
    }

    public static Descriptor build(Annotation ... annotations) {
        Preconditions.checkNotNull(annotations);
        log.trace("Building descriptor for annotations: {}", (Object)Arrays.asList(annotations));
        TreeMap<String, String[]> fields = Maps.newTreeMap();
        for (Annotation annotation : DescriptorHelper.findAllAnnotations(annotations)) {
            log.trace("Scanning annotation: {}", (Object)annotation);
            Method[] methodArray = annotation.annotationType().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                log.trace("Scanning method: {}", (Object)method);
                DescriptorKey key = method.getAnnotation(DescriptorKey.class);
                if (key != null) {
                    log.trace("Found key: {}", (Object)key);
                    String name = key.value();
                    String[] value = null;
                    try {
                        value = method.invoke((Object)annotation, new Object[0]);
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked(e);
                        throw new RuntimeException(e);
                    }
                    if (value != null) {
                        if (value instanceof Class) {
                            value = ((Class)value).getCanonicalName();
                        } else if (value instanceof Enum) {
                            value = ((Enum)value).name();
                        } else if (value.getClass().isArray()) {
                            int i;
                            String[] strings;
                            Class<?> componentType = value.getClass().getComponentType();
                            if (Class.class.equals(componentType)) {
                                Class[] classes = (Class[])value;
                                strings = new String[classes.length];
                                i = 0;
                                while (i < classes.length) {
                                    strings[i] = classes[i].getName();
                                    ++i;
                                }
                                value = strings;
                            } else if (Enum.class.equals(componentType)) {
                                Enum[] enums = (Enum[])value;
                                strings = new String[enums.length];
                                i = 0;
                                while (i < enums.length) {
                                    strings[i] = enums[i].name();
                                    ++i;
                                }
                                value = strings;
                            } else if (Annotation.class.equals(componentType)) {
                                throw new InvalidDescriptorKeyException(key, annotation, method);
                            }
                        } else if (value instanceof Annotation) {
                            throw new InvalidDescriptorKeyException(key, annotation, method);
                        }
                        fields.put(name, value);
                    }
                }
                ++n2;
            }
        }
        return new ImmutableDescriptor(fields);
    }

    @VisibleForTesting
    static List<Annotation> findAllAnnotations(Annotation ... annotations) {
        HashSet<Annotation> visited = Sets.newHashSet();
        ArrayList<Annotation> found = Lists.newArrayList();
        DescriptorHelper.visitAnnotations(visited, found, annotations);
        return found;
    }

    private static void visitAnnotations(Set<Annotation> visited, List<Annotation> found, Annotation ... annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            visited.add(annotation);
            Annotation[] annotationArray2 = annotation.annotationType().getAnnotations();
            int n3 = annotationArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation parent = annotationArray2[n4];
                if (!visited.contains(parent)) {
                    DescriptorHelper.visitAnnotations(visited, found, parent);
                }
                ++n4;
            }
            found.add(annotation);
            ++n2;
        }
    }

    @Nullable
    public static String stringValue(Descriptor descriptor, String name) {
        Preconditions.checkNotNull(descriptor);
        Preconditions.checkNotNull(name);
        Object value = descriptor.getFieldValue(name);
        if (value instanceof CharSequence) {
            return value.toString();
        }
        return null;
    }

    @VisibleForTesting
    static class InvalidDescriptorKeyException
    extends RuntimeException {
        public InvalidDescriptorKeyException(DescriptorKey key, Annotation annotation, Method method) {
            super("Invalid @DescriptorKey: " + key + ", annotation=" + annotation + ", method=" + method);
        }
    }
}

