/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.task;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.sonatype.nexus.logging.task.ProgressTaskLogger;
import org.sonatype.nexus.logging.task.TaskLogHome;
import org.sonatype.nexus.logging.task.TaskLogInfo;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

public class ReplicationTaskLogger
extends ProgressTaskLogger {
    public static final String REPLICATION_LOG_LOCATION_PREFIX = "running replication task for repository '{}' , replication log : {}";
    public static final String REPLICATION_DISCRIMINATOR_ID = "repositoryName";
    private final TaskLogInfo taskLogInfo;
    private final String repositoryName;

    ReplicationTaskLogger(Logger log, TaskLogInfo taskLogInfo) {
        super(log);
        this.taskLogInfo = Preconditions.checkNotNull(taskLogInfo);
        this.repositoryName = taskLogInfo.getString(REPLICATION_DISCRIMINATOR_ID);
        MDC.put("TASK_LOG_ONLY_MDC", "true");
        MDC.put(REPLICATION_DISCRIMINATOR_ID, this.repositoryName);
    }

    private void logReplicationRunInfo() {
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Replication run info:");
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, " Task ID: {}", (Object)this.taskLogInfo.getId());
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, " Type: {}", (Object)this.taskLogInfo.getTypeId());
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, " Name: {}", (Object)this.taskLogInfo.getName());
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, " Description: {}", (Object)this.taskLogInfo.getMessage());
        this.writeReplicationRunOnNexusLog();
    }

    private void writeReplicationRunOnNexusLog() {
        MDC.remove("TASK_LOG_ONLY_MDC");
        TaskLogHome.getReplicationLogsHome().ifPresent(home -> {
            String identifier = "replication-" + this.repositoryName + ".log";
            String filename = String.format("%s/%s", home, identifier);
            this.log.info(TaskLoggingMarkers.NEXUS_LOG_ONLY, REPLICATION_LOG_LOCATION_PREFIX, (Object)this.repositoryName, (Object)filename);
        });
        MDC.put("TASK_LOG_ONLY_MDC", "true");
    }

    @Override
    public final void start() {
        super.start();
        this.logReplicationRunInfo();
    }

    @Override
    public final void finish() {
        super.finish();
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task complete");
        MDC.remove("TASK_LOG_ONLY_MDC");
        MDC.remove(REPLICATION_DISCRIMINATOR_ID);
    }

    @Override
    public void flush() {
        if (this.lastProgressEvent != null) {
            Logger logger = Optional.ofNullable(this.lastProgressEvent.getLogger()).orElse(this.log);
            logger.info(TaskLoggingMarkers.PROGRESS, this.lastProgressEvent.getMessage(), this.lastProgressEvent.getArgumentArray());
        }
        super.flush();
    }
}

