/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import javax.inject.Provider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.upgrade.Checkpoint;
import org.sonatype.nexus.orient.DatabaseInstance;

public abstract class DatabaseCheckpointSupport
extends ComponentSupport
implements Checkpoint {
    private final String databaseName;
    private final Provider<DatabaseInstance> databaseInstance;
    private final ApplicationDirectories appDirectories;
    private File upgradeDir;
    private File backupZip;
    private File failedZip;

    protected DatabaseCheckpointSupport(String databaseName, Provider<DatabaseInstance> databaseInstance, ApplicationDirectories appDirectories) {
        this.databaseName = Preconditions.checkNotNull(databaseName);
        this.databaseInstance = Preconditions.checkNotNull(databaseInstance);
        this.appDirectories = Preconditions.checkNotNull(appDirectories);
    }

    @Override
    public void begin(String version) throws Exception {
        this.upgradeDir = this.appDirectories.getWorkDirectory("upgrades/" + this.databaseName);
        String timestampSuffix = String.format("-%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS", System.currentTimeMillis());
        this.backupZip = new File(this.upgradeDir, String.valueOf(this.databaseName) + "-" + version + timestampSuffix + "-backup.zip");
        this.failedZip = new File(this.upgradeDir, String.valueOf(this.databaseName) + "-failed.zip");
        this.log.debug("Backing up database to {}", (Object)this.backupZip);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream out = new FileOutputStream(this.backupZip);){
            this.databaseInstance.get().externalizer().backup(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void commit() throws Exception {
    }

    @Override
    public void rollback() throws Exception {
        Preconditions.checkState(this.failedZip != null);
        Preconditions.checkState(this.backupZip != null);
        this.log.debug("Exporting failed database to {}", (Object)this.failedZip);
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileOutputStream out = new FileOutputStream(this.failedZip);){
                this.databaseInstance.get().externalizer().backup(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.log.debug("Restoring original database from {}", (Object)this.backupZip);
            Throwable throwable = null;
            Object var6_13 = null;
            try (FileInputStream in = new FileInputStream(this.backupZip);){
                this.databaseInstance.get().externalizer().restore(in, true);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void end() {
        Preconditions.checkState(this.upgradeDir != null);
        Preconditions.checkState(this.backupZip != null);
        this.log.debug("Deleting backup from {}", (Object)this.upgradeDir);
        try {
            Files.delete(this.backupZip.toPath());
            Files.delete(this.upgradeDir.toPath());
        }
        catch (IOException e) {
            this.log.warn("Could not delete backup of {} database, please delete {} manually. Error: {}", this.databaseName, this.upgradeDir, e.toString());
        }
        this.backupZip = null;
        this.failedZip = null;
        this.upgradeDir = null;
    }
}

