/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.goodies.lifecycle.Lifecycles;
import org.sonatype.nexus.orient.DatabaseExternalizerImpl;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseInstanceImpl;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.DatabasePool;
import org.sonatype.nexus.orient.DatabasePoolImpl;
import org.sonatype.nexus.orient.DatabasePoolSupport;
import org.sonatype.nexus.orient.DatabasePoolWithOverflowImpl;
import org.sonatype.nexus.orient.ExplainODatabaseDocumentTx;

public abstract class DatabaseManagerSupport
extends LifecycleSupport
implements DatabaseManager {
    private static final int DEFAULT_MAX_CONNECTIONS_PER_CORE = 16;
    private static final int DEFAULT_MAX_CONNECTIONS = -1;
    private static final String MAX_CONNECTIONS_PER_CORE_PROPERTY = "nexus.orient.maxConnectionsPerCore";
    private static final String MAX_CONNECTIONS_PROPERTY = "nexus.orient.maxConnections";
    private static final String MAX_CONNECTIONS_PER_CORE_PLACEHOLDER = "${nexus.orient.maxConnectionsPerCore:-16}";
    private static final String MAX_CONNECTIONS_PLACEHOLDER = "${nexus.orient.maxConnections:--1}";
    public static final String SYSTEM_USER = "admin";
    public static final String SYSTEM_PASSWORD = "admin";
    public static final int DEFAULT_BUFFER_SIZE_IN_BYTES = 16384;
    public static final int DEFAULT_COMPRESSION_LEVEL = 3;
    private static final String NEXUS_BACKUP_BUFFER_SIZE_PROPERTY = "${nexus.backup.bufferSize:-16384}";
    private static final String NEXUS_BACKUP_IMPORT_BUFFER_SIZE_PROPERTY = "${nexus.backup.importBufferSize:-16384}";
    private static final String NEXUS_BACKUP_COMPRESSION_LEVEL_PROPERTY = "${nexus.backup.compressionLevel:-3}";
    private static final String EXPLAIN_PREFIX = "org.sonatype.nexus.orient.explain.";
    private final Map<String, DatabasePoolSupport> pools = Maps.newHashMap();
    private final Map<String, DatabaseInstanceImpl> instances = Maps.newConcurrentMap();
    private int maxConnectionsPerCore = 16;
    private int maxConnections = -1;
    private int backupBufferSize = 16384;
    private int backupCompressionLevel = 3;
    private int importBufferSize = 16384;

    @Inject
    public void setMaxConnectionsPerCore(@Named(value="${nexus.orient.maxConnectionsPerCore:-16}") @Named(value="${nexus.orient.maxConnectionsPerCore:-16}") int maxConnectionsPerCore) {
        this.maxConnectionsPerCore = maxConnectionsPerCore;
    }

    @Inject
    public void setMaxConnections(@Named(value="${nexus.orient.maxConnections:--1}") @Named(value="${nexus.orient.maxConnections:--1}") int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Inject
    public void setBackupBufferSize(@Named(value="${nexus.backup.bufferSize:-16384}") @Named(value="${nexus.backup.bufferSize:-16384}") int backupBufferSize) {
        this.backupBufferSize = backupBufferSize;
    }

    @Inject
    public void setBackupCompressionLevel(@Named(value="${nexus.backup.compressionLevel:-3}") @Named(value="${nexus.backup.compressionLevel:-3}") int backupCompressionLevel) {
        this.backupCompressionLevel = backupCompressionLevel;
    }

    @Inject
    public void setImportBufferSize(@Named(value="${nexus.backup.importBufferSize:-16384}") @Named(value="${nexus.backup.importBufferSize:-16384}") int importBufferSize) {
        this.importBufferSize = importBufferSize;
    }

    @Override
    protected void doStart() throws Exception {
        Preconditions.checkState(this.pools.isEmpty());
    }

    @Override
    protected void doStop() throws Exception {
        this.instances.values().forEach(DatabaseInstanceImpl::releasePool);
        this.stopAllPools();
    }

    private void stopAllPools() {
        if (this.pools.isEmpty()) {
            return;
        }
        this.log.info("Stopping {} pools", (Object)this.pools.size());
        Iterator<DatabasePoolSupport> iter = this.pools.values().iterator();
        while (iter.hasNext()) {
            DatabasePoolSupport pool = iter.next();
            if (pool.isStarted()) {
                this.log.info("Stopping pool: {}", (Object)pool.getName());
                try {
                    pool.stop();
                }
                catch (Exception e) {
                    this.log.warn("Failed to stop pool: {}", (Object)pool.getName(), (Object)e);
                }
            } else {
                this.log.info("Pool already stopped: {}", (Object)pool.getName());
            }
            iter.remove();
        }
    }

    protected abstract String connectionUri(String var1);

    @Override
    public ODatabaseDocumentTx connect(String name, boolean create) {
        Preconditions.checkNotNull(name);
        this.ensureStarted();
        String uri = this.connectionUri(name);
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(uri);
        if (db.exists()) {
            db.open("admin", "admin");
            this.log.debug("Opened database: {} -> {}", (Object)name, (Object)db);
        } else if (create) {
            db.create();
            this.log.debug("Created database: {} -> {}", (Object)name, (Object)db);
            try {
                this.created(db, name);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        } else {
            this.log.debug("Database does not exist: {}", (Object)name);
        }
        return db;
    }

    protected void created(ODatabaseDocumentTx db, String name) throws Exception {
    }

    @Override
    public DatabaseExternalizerImpl externalizer(String name) {
        Preconditions.checkNotNull(name);
        this.ensureStarted();
        return new DatabaseExternalizerImpl(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabasePool pool(String name) {
        Preconditions.checkNotNull(name);
        this.ensureStarted();
        Map<String, DatabasePoolSupport> map = this.pools;
        synchronized (map) {
            DatabasePoolSupport pool = this.pools.get(name);
            if (pool == null) {
                pool = this.createPool(name);
                this.log.debug("Created database pool: {}", (Object)pool);
                this.pools.put(name, pool);
            }
            return pool;
        }
    }

    @Override
    public DatabasePool newPool(String name) {
        Preconditions.checkNotNull(name);
        this.ensureStarted();
        return this.createPool(name);
    }

    private DatabasePoolSupport createPool(String name) {
        DatabasePoolSupport pool;
        String uri = this.connectionUri(name);
        OPartitionedDatabasePool underlying = new OPartitionedDatabasePool(uri, "admin", "admin", this.maxConnectionsPerCore, this.maxConnections);
        if (this.maxConnections > 0) {
            this.log.info("Configuring OrientDB pool {} with overall limit of {}", (Object)name, (Object)this.maxConnections);
            pool = new DatabasePoolImpl(underlying, name);
        } else if (this.maxConnectionsPerCore > 0) {
            OPartitionedDatabasePool overflow = new OPartitionedDatabasePool(uri, "admin", "admin", -1, this.maxConnectionsPerCore);
            this.log.info("Configuring OrientDB pool {} with per-core limit of {}", (Object)name, (Object)this.maxConnectionsPerCore);
            pool = new DatabasePoolWithOverflowImpl(underlying, overflow, name);
        } else {
            throw new IllegalArgumentException("Either nexus.orient.maxConnectionsPerCore or nexus.orient.maxConnections must be positive");
        }
        Lifecycles.start(pool);
        return pool;
    }

    @Override
    public DatabaseInstance instance(String name) {
        Preconditions.checkNotNull(name);
        this.ensureStarted();
        return this.instances.computeIfAbsent(name, this::createInstance);
    }

    private DatabaseInstanceImpl createInstance(final String name) {
        final Logger explainLogger = LoggerFactory.getLogger(EXPLAIN_PREFIX + name);
        DatabaseInstanceImpl instance = explainLogger.isDebugEnabled() ? new DatabaseInstanceImpl(this, name){

            @Override
            public ODatabaseDocumentTx acquire() {
                String uri = DatabaseManagerSupport.this.connectionUri(name);
                ExplainODatabaseDocumentTx db = new ExplainODatabaseDocumentTx(uri, explainLogger);
                db.open("admin", "admin");
                return db;
            }
        } : new DatabaseInstanceImpl(this, name);
        this.connect(name, true).close();
        this.log.debug("Created database instance: {}", (Object)instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceStorage(OStorage storage) {
        DatabasePoolSupport pool;
        Map<String, DatabasePoolSupport> map = this.pools;
        synchronized (map) {
            pool = this.pools.get(storage.getName());
        }
        if (pool != null) {
            pool.replaceStorage(storage);
        }
    }

    @Override
    public int getBackupCompressionLevel() {
        return this.backupCompressionLevel;
    }

    @Override
    public int getBackupBufferSize() {
        return this.backupBufferSize;
    }

    @Override
    public int getImportBufferSize() {
        return this.importBufferSize;
    }
}

