/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;

public class OIndexNameBuilder {
    public static final String TYPE_SEPARATOR = "_";
    public static final String PROPERTY_SEPARATOR = "_";
    public static final String CASE_INSENSITIVE = "_ci";
    public static final String SUFFIX = "_idx";
    private String type;
    private List<String> properties = Lists.newArrayList();
    private boolean caseInsensitive;

    public OIndexNameBuilder type(String type) {
        this.type = type;
        return this;
    }

    public OIndexNameBuilder property(String property) {
        this.properties.add(property);
        return this;
    }

    public OIndexNameBuilder caseInsensitive() {
        this.caseInsensitive = true;
        return this;
    }

    public String build() {
        Preconditions.checkState(!this.properties.isEmpty(), "At least one property required");
        StringBuilder buff = new StringBuilder();
        if (this.type != null) {
            buff.append(this.type);
            buff.append("_");
        }
        Joiner.on("_").appendTo(buff, (Iterable<? extends Object>)this.properties);
        if (this.caseInsensitive) {
            buff.append(CASE_INSENSITIVE);
        }
        buff.append(SUFFIX);
        return buff.toString().toLowerCase(Locale.US);
    }
}

