/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.util.function.Predicate;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

public class BrowseEntitiesWithPredicateAction<T extends Entity>
extends ComponentSupport {
    private final IterableEntityAdapter<T> adapter;

    public BrowseEntitiesWithPredicateAction(IterableEntityAdapter<T> adapter) {
        this.adapter = Preconditions.checkNotNull(adapter);
    }

    public Iterable<T> execute(ODatabaseDocumentTx db, Predicate<T> predicate) {
        Preconditions.checkNotNull(db);
        Preconditions.checkNotNull(predicate);
        return Iterables.filter(this.adapter.transform(this.adapter.browseDocuments(db)), predicate::test);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "type='" + this.adapter.getTypeName() + '\'' + '}';
    }
}

