/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public class ReadEntityByIdAction<T extends Entity>
extends ComponentSupport {
    private final EntityAdapter<T> adapter;

    public ReadEntityByIdAction(EntityAdapter<T> adapter) {
        this.adapter = Preconditions.checkNotNull(adapter);
    }

    @Nullable
    public T execute(ODatabaseDocumentTx db, EntityId id) {
        Preconditions.checkNotNull(db);
        Preconditions.checkNotNull(id);
        ODocument doc = this.adapter.document(db, id);
        return doc != null ? (T)this.adapter.readEntity(doc) : null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "type='" + this.adapter.getTypeName() + '\'' + '}';
    }
}

