/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.internal.freeze;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.orient.freeze.DatabaseFrozenStateManager;
import org.sonatype.nexus.orient.freeze.FreezeRequest;

@Named(value="local")
@Singleton
public class LocalDatabaseFrozenStateManager
extends ComponentSupport
implements DatabaseFrozenStateManager {
    private static final String FROZEN_MARKER = "frozen.marker";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final File frozenMarkerFile;

    @Inject
    public LocalDatabaseFrozenStateManager(ApplicationDirectories applicationDirectories) {
        this.frozenMarkerFile = new File(applicationDirectories.getWorkDirectory("db"), FROZEN_MARKER);
        this.objectMapper.registerModule(new JodaModule());
        this.objectMapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    }

    @Override
    public synchronized List<FreezeRequest> getState() {
        return this.readMarkerFile();
    }

    @Override
    public synchronized boolean remove(FreezeRequest request) {
        List<FreezeRequest> requests = this.readMarkerFile();
        if (requests.remove(request)) {
            this.writeMarkerFile(requests);
            return true;
        }
        return false;
    }

    @Override
    public synchronized FreezeRequest add(FreezeRequest request) {
        List<FreezeRequest> requests = this.readMarkerFile();
        if (requests.add(request)) {
            this.writeMarkerFile(requests);
            return request;
        }
        return null;
    }

    private File markerFile() {
        if (!Files.exists(this.frozenMarkerFile.toPath(), new LinkOption[0])) {
            try {
                Files.createFile(this.frozenMarkerFile.toPath(), new FileAttribute[0]);
                this.objectMapper.writeValue(this.frozenMarkerFile, Collections.emptyList());
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to create database frozen state marker file", e);
            }
        }
        return this.frozenMarkerFile;
    }

    private void writeMarkerFile(List<FreezeRequest> requests) {
        try {
            this.objectMapper.writeValue(this.markerFile(), requests);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to write database frozen state marker file", e);
        }
    }

    private List<FreezeRequest> readMarkerFile() {
        try {
            return this.objectMapper.readValue(this.markerFile(), new TypeReference<List<FreezeRequest>>(){});
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to read database frozen state marker file", e);
        }
    }
}

