/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security;

import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.security.PhraseService;

public abstract class AbstractPhraseService
extends ComponentSupport
implements PhraseService {
    private final boolean hasMasterPhrase;

    public AbstractPhraseService(boolean hasMasterPhrase) {
        this.hasMasterPhrase = hasMasterPhrase;
    }

    protected abstract String getMasterPhrase();

    @Override
    public String getPhrase(String defaultPhrase) {
        return this.hasMasterPhrase ? this.getMasterPhrase() : defaultPhrase;
    }

    @Override
    public String mark(String value) {
        if (this.hasMasterPhrase && value != null && !value.contains("~{")) {
            return value.replace("{", "~{").replace("}", "}~");
        }
        return value;
    }

    @Override
    public boolean usesLegacyEncoding(String value) {
        return !this.hasMasterPhrase || value == null || !value.contains("~{");
    }
}

