/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.security.realm.RealmConfiguration;
import org.sonatype.nexus.security.realm.RealmConfigurationStore;

@Named(value="initial")
@Singleton
public class InitialRealmConfigurationProvider
implements Provider<RealmConfiguration> {
    private final RealmConfigurationStore store;

    @Inject
    public InitialRealmConfigurationProvider(RealmConfigurationStore store) {
        this.store = Preconditions.checkNotNull(store);
    }

    @Override
    public RealmConfiguration get() {
        RealmConfiguration configuration = this.store.newEntity();
        configuration.setRealmNames(Lists.newArrayList("NexusAuthenticatingRealm", "NexusAuthorizingRealm"));
        return configuration;
    }
}

