/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.springframework.util.StringUtils;

public class ExitStatus
implements Serializable,
Comparable<ExitStatus> {
    public static final ExitStatus UNKNOWN = new ExitStatus("UNKNOWN");
    public static final ExitStatus EXECUTING = new ExitStatus("EXECUTING");
    public static final ExitStatus COMPLETED = new ExitStatus("COMPLETED");
    public static final ExitStatus NOOP = new ExitStatus("NOOP");
    public static final ExitStatus FAILED = new ExitStatus("FAILED");
    public static final ExitStatus STOPPED = new ExitStatus("STOPPED");
    private final String exitCode;
    private final String exitDescription;

    public ExitStatus(String exitCode) {
        this(exitCode, "");
    }

    public ExitStatus(String exitCode, String exitDescription) {
        this.exitCode = exitCode;
        this.exitDescription = exitDescription == null ? "" : exitDescription;
    }

    public String getExitCode() {
        return this.exitCode;
    }

    public String getExitDescription() {
        return this.exitDescription;
    }

    public ExitStatus and(ExitStatus status) {
        if (status == null) {
            return this;
        }
        ExitStatus result = this.addExitDescription(status.exitDescription);
        if (this.compareTo(status) < 0) {
            result = result.replaceExitCode(status.exitCode);
        }
        return result;
    }

    @Override
    public int compareTo(ExitStatus status) {
        if (this.severity(status) > this.severity(this)) {
            return -1;
        }
        if (this.severity(status) < this.severity(this)) {
            return 1;
        }
        return this.getExitCode().compareTo(status.getExitCode());
    }

    private int severity(ExitStatus status) {
        if (status.exitCode.startsWith(ExitStatus.EXECUTING.exitCode)) {
            return 1;
        }
        if (status.exitCode.startsWith(ExitStatus.COMPLETED.exitCode)) {
            return 2;
        }
        if (status.exitCode.startsWith(ExitStatus.NOOP.exitCode)) {
            return 3;
        }
        if (status.exitCode.startsWith(ExitStatus.STOPPED.exitCode)) {
            return 4;
        }
        if (status.exitCode.startsWith(ExitStatus.FAILED.exitCode)) {
            return 5;
        }
        if (status.exitCode.startsWith(ExitStatus.UNKNOWN.exitCode)) {
            return 6;
        }
        return 7;
    }

    public String toString() {
        return String.format("exitCode=%s;exitDescription=%s", this.exitCode, this.exitDescription);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ExitStatus replaceExitCode(String code) {
        return new ExitStatus(code, this.exitDescription);
    }

    public boolean isRunning() {
        return "EXECUTING".equals(this.exitCode) || "UNKNOWN".equals(this.exitCode);
    }

    public ExitStatus addExitDescription(String description) {
        if (StringUtils.hasText(this.exitDescription)) {
            if (StringUtils.hasText(description) && !this.exitDescription.equals(description)) {
                StringBuilder buffer = new StringBuilder(description.length() + 2 + this.exitDescription.length());
                buffer.append(this.exitDescription);
                buffer.append("; ");
                buffer.append(description);
                return new ExitStatus(this.exitCode, buffer.toString());
            }
            return this;
        }
        return new ExitStatus(this.exitCode, description);
    }

    public ExitStatus addExitDescription(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        String message = writer.toString();
        return this.addExitDescription(message);
    }

    public static boolean isNonDefaultExitStatus(ExitStatus status) {
        return status == null || status.getExitCode() == null || status.getExitCode().equals(COMPLETED.getExitCode()) || status.getExitCode().equals(EXECUTING.getExitCode()) || status.getExitCode().equals(FAILED.getExitCode()) || status.getExitCode().equals(NOOP.getExitCode()) || status.getExitCode().equals(STOPPED.getExitCode()) || status.getExitCode().equals(UNKNOWN.getExitCode());
    }
}

