/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.StepRegistry;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.JobLoader;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultJobLoader
implements JobLoader,
InitializingBean {
    private static Log logger = LogFactory.getLog(DefaultJobLoader.class);
    private JobRegistry jobRegistry;
    private StepRegistry stepRegistry;
    private Map<ApplicationContextFactory, ConfigurableApplicationContext> contexts = new ConcurrentHashMap<ApplicationContextFactory, ConfigurableApplicationContext>();
    private Map<ConfigurableApplicationContext, Collection<String>> contextToJobNames = new ConcurrentHashMap<ConfigurableApplicationContext, Collection<String>>();

    public DefaultJobLoader() {
        this(null, null);
    }

    public DefaultJobLoader(JobRegistry jobRegistry) {
        this(jobRegistry, null);
    }

    public DefaultJobLoader(JobRegistry jobRegistry, @Nullable StepRegistry stepRegistry) {
        this.jobRegistry = jobRegistry;
        this.stepRegistry = stepRegistry;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setStepRegistry(StepRegistry stepRegistry) {
        this.stepRegistry = stepRegistry;
    }

    @Override
    public void clear() {
        for (ConfigurableApplicationContext context : this.contexts.values()) {
            if (!context.isActive()) continue;
            context.close();
        }
        for (String jobName : this.jobRegistry.getJobNames()) {
            this.doUnregister(jobName);
        }
        this.contexts.clear();
        this.contextToJobNames.clear();
    }

    @Override
    public Collection<Job> reload(ApplicationContextFactory factory) {
        if (this.contexts.containsKey(factory)) {
            ConfigurableApplicationContext context = this.contexts.get(factory);
            for (String name : this.contextToJobNames.get(context)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregistering job: " + name + " from context: " + context.getDisplayName());
                }
                this.doUnregister(name);
            }
            context.close();
        }
        try {
            return this.doLoad(factory, true);
        }
        catch (DuplicateJobException e) {
            throw new IllegalStateException("Found duplicate job in reload (it should have been unregistered if it was previously registered in this loader)", e);
        }
    }

    @Override
    public Collection<Job> load(ApplicationContextFactory factory) throws DuplicateJobException {
        return this.doLoad(factory, false);
    }

    /*
     * WARNING - void declaration
     */
    private Collection<Job> doLoad(ApplicationContextFactory factory, boolean unregister) throws DuplicateJobException {
        void var11_15;
        String[] names;
        Collection<String> jobNamesBefore = this.jobRegistry.getJobNames();
        ConfigurableApplicationContext context = factory.createApplicationContext();
        Collection<String> jobNamesAfter = this.jobRegistry.getJobNames();
        boolean autoRegistrationDetected = jobNamesAfter.size() > jobNamesBefore.size();
        HashSet<String> jobsRegistered = new HashSet<String>();
        if (autoRegistrationDetected) {
            for (String string : jobNamesAfter) {
                if (jobNamesBefore.contains(string)) continue;
                jobsRegistered.add(string);
            }
        }
        this.contexts.put(factory, context);
        String[] stringArray = names = context.getBeanNamesForType(Job.class);
        int n = stringArray.length;
        boolean bl = false;
        while (var11_15 < n) {
            String name = stringArray[var11_15];
            if (!autoRegistrationDetected) {
                Job job = (Job)context.getBean(name);
                String jobName = job.getName();
                if (unregister) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Unregistering job: " + jobName + " from context: " + context.getDisplayName());
                    }
                    this.doUnregister(jobName);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering job: " + jobName + " from context: " + context.getDisplayName());
                }
                this.doRegister(context, job);
                jobsRegistered.add(jobName);
            }
            ++var11_15;
        }
        ArrayList<Job> arrayList = new ArrayList<Job>();
        for (String string : jobsRegistered) {
            try {
                arrayList.add(this.jobRegistry.getJob(string));
            }
            catch (NoSuchJobException e) {
                throw new IllegalStateException("Could not retrieve job that was should have been registered", e);
            }
        }
        this.contextToJobNames.put(context, jobsRegistered);
        return arrayList;
    }

    private Collection<Step> getSteps(StepLocator stepLocator, ApplicationContext jobApplicationContext) {
        Collection<String> stepNames = stepLocator.getStepNames();
        ArrayList<Step> result = new ArrayList<Step>();
        for (String stepName : stepNames) {
            result.add(stepLocator.getStep(stepName));
        }
        Map<String, Step> allSteps = jobApplicationContext.getBeansOfType(Step.class);
        for (Map.Entry<String, Step> entry : allSteps.entrySet()) {
            if (stepNames.contains(entry.getKey())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    private void doRegister(ConfigurableApplicationContext context, Job job) throws DuplicateJobException {
        ReferenceJobFactory jobFactory = new ReferenceJobFactory(job);
        this.jobRegistry.register(jobFactory);
        if (this.stepRegistry != null) {
            if (!(job instanceof StepLocator)) {
                throw new UnsupportedOperationException("Cannot locate steps from a Job that is not a StepLocator: job=" + job.getName() + " does not implement StepLocator");
            }
            this.stepRegistry.register(job.getName(), this.getSteps((StepLocator)((Object)job), context));
        }
    }

    private void doUnregister(String jobName) {
        this.jobRegistry.unregister(jobName);
        if (this.stepRegistry != null) {
            this.stepRegistry.unregisterStepsFromJob(jobName);
        }
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.jobRegistry, "Job registry could not be null.");
    }
}

