/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.metrics;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;

public final class BatchMetrics {
    private static final String METRICS_PREFIX = "spring.batch.";
    public static final String STATUS_SUCCESS = "SUCCESS";
    public static final String STATUS_FAILURE = "FAILURE";

    private BatchMetrics() {
    }

    public static Timer createTimer(String name, String description, Tag ... tags) {
        return ((Timer.Builder)Timer.builder(METRICS_PREFIX + name).description(description).tags(Arrays.asList(tags))).register(Metrics.globalRegistry);
    }

    public static Timer.Sample createTimerSample() {
        return Timer.start(Metrics.globalRegistry);
    }

    public static LongTaskTimer createLongTaskTimer(String name, String description, Tag ... tags) {
        return LongTaskTimer.builder(METRICS_PREFIX + name).description(description).tags(Arrays.asList(tags)).register(Metrics.globalRegistry);
    }

    @Nullable
    public static Duration calculateDuration(@Nullable Date startTime, @Nullable Date endTime) {
        if (startTime == null || endTime == null) {
            return null;
        }
        return Duration.between(startTime.toInstant(), endTime.toInstant());
    }

    public static String formatDuration(@Nullable Duration duration) {
        if (duration == null || duration.isZero() || duration.isNegative()) {
            return "";
        }
        StringBuilder formattedDuration = new StringBuilder();
        long hours = duration.toHours();
        long minutes = duration.toMinutes();
        long seconds = duration.getSeconds();
        long millis = duration.toMillis();
        if (hours != 0L) {
            formattedDuration.append(hours).append("h");
        }
        if (minutes != 0L) {
            formattedDuration.append(minutes - TimeUnit.HOURS.toMinutes(hours)).append("m");
        }
        if (seconds != 0L) {
            formattedDuration.append(seconds - TimeUnit.MINUTES.toSeconds(minutes)).append("s");
        }
        if (millis != 0L) {
            formattedDuration.append(millis - TimeUnit.SECONDS.toMillis(seconds)).append("ms");
        }
        return formattedDuration.toString();
    }
}

