/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.scope.BatchScopeSupport;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.ObjectFactory;

public class StepScope
extends BatchScopeSupport {
    private static final String TARGET_NAME_PREFIX = "scopedTarget.";
    private Log logger = LogFactory.getLog(this.getClass());
    private final Object mutex = new Object();
    public static final String ID_KEY = "STEP_IDENTIFIER";

    public StepScope() {
        this.setName("step");
    }

    @Override
    public Object resolveContextualObject(String key) {
        StepContext context = this.getContext();
        return new BeanWrapperImpl(context).getPropertyValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String name, ObjectFactory<?> objectFactory) {
        StepContext context = this.getContext();
        Object scopedObject = context.getAttribute(name);
        if (scopedObject == null) {
            Object object = this.mutex;
            synchronized (object) {
                scopedObject = context.getAttribute(name);
                if (scopedObject == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(String.format("Creating object in scope=%s, name=%s", this.getName(), name));
                    }
                    scopedObject = objectFactory.getObject();
                    context.setAttribute(name, scopedObject);
                }
            }
        }
        return scopedObject;
    }

    @Override
    public String getConversationId() {
        StepContext context = this.getContext();
        return context.getId();
    }

    @Override
    public void registerDestructionCallback(String name, Runnable callback) {
        StepContext context = this.getContext();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Registered destruction callback in scope=%s, name=%s", this.getName(), name));
        }
        context.registerDestructionCallback(name, callback);
    }

    @Override
    public Object remove(String name) {
        StepContext context = this.getContext();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Removing from scope=%s, name=%s", this.getName(), name));
        }
        return context.removeAttribute(name);
    }

    private StepContext getContext() {
        StepContext context = StepSynchronizationManager.getContext();
        if (context == null) {
            throw new IllegalStateException("No context holder available for step scope");
        }
        return context;
    }

    @Override
    public String getTargetNamePrefix() {
        return TARGET_NAME_PREFIX;
    }
}

