/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.avro.builder;

import org.springframework.batch.item.avro.AvroItemWriter;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;

public class AvroItemWriterBuilder<T> {
    private Class<T> type;
    private WritableResource resource;
    private Resource schema;
    private String name = AvroItemWriter.class.getSimpleName();

    public AvroItemWriterBuilder<T> resource(WritableResource resource) {
        Assert.notNull((Object)resource, "A 'resource' is required.");
        this.resource = resource;
        return this;
    }

    public AvroItemWriterBuilder<T> schema(Resource schema) {
        Assert.notNull((Object)schema, "A 'schema' is required.");
        Assert.state(schema.exists(), "Resource " + schema.getFilename() + "does not exist.");
        this.schema = schema;
        return this;
    }

    public AvroItemWriterBuilder<T> schema(String schemaString) {
        Assert.hasText(schemaString, "A 'schemaString' is required.");
        this.schema = new ByteArrayResource(schemaString.getBytes());
        return this;
    }

    public AvroItemWriterBuilder<T> type(Class<T> type) {
        Assert.notNull(type, "A 'type' is required.");
        this.type = type;
        return this;
    }

    public AvroItemWriterBuilder<T> name(String name) {
        Assert.hasText(name, "A 'name' is required.");
        this.name = name;
        return this;
    }

    public AvroItemWriter<T> build() {
        Assert.notNull((Object)this.resource, "A 'resource' is required.");
        Assert.notNull(this.type, "A 'type' is required.");
        AvroItemWriter<T> avroItemWriter = this.schema != null ? new AvroItemWriter<T>(this.resource, this.schema, this.type) : new AvroItemWriter<T>(this.resource, this.type);
        avroItemWriter.setName(this.name);
        return avroItemWriter;
    }
}

