/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class Neo4jItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(Neo4jItemWriter.class);
    private boolean delete = false;
    private SessionFactory sessionFactory;

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.sessionFactory != null, "A SessionFactory is required");
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        if (!CollectionUtils.isEmpty(items)) {
            this.doWrite(items);
        }
    }

    protected void doWrite(List<? extends T> items) {
        if (this.delete) {
            this.delete(items);
        } else {
            this.save(items);
        }
    }

    private void delete(List<? extends T> items) {
        Session session = this.sessionFactory.openSession();
        for (T item : items) {
            session.delete(item);
        }
    }

    private void save(List<? extends T> items) {
        Session session = this.sessionFactory.openSession();
        for (T item : items) {
            session.save(item);
        }
    }
}

