/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.builder;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.springframework.batch.item.database.JpaCursorItemReader;
import org.springframework.batch.item.database.orm.JpaQueryProvider;
import org.springframework.util.Assert;

public class JpaCursorItemReaderBuilder<T> {
    private EntityManagerFactory entityManagerFactory;
    private String queryString;
    private JpaQueryProvider queryProvider;
    private Map<String, Object> parameterValues;
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public JpaCursorItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> queryProvider(JpaQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public JpaCursorItemReaderBuilder<T> entityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        return this;
    }

    public JpaCursorItemReader<T> build() {
        Assert.notNull((Object)this.entityManagerFactory, "An EntityManagerFactory is required");
        if (this.saveState) {
            Assert.hasText(this.name, "A name is required when saveState is set to true");
        }
        if (this.queryProvider == null) {
            Assert.hasLength(this.queryString, "Query string is required when queryProvider is null");
        }
        JpaCursorItemReader reader = new JpaCursorItemReader();
        reader.setEntityManagerFactory(this.entityManagerFactory);
        reader.setQueryProvider(this.queryProvider);
        reader.setQueryString(this.queryString);
        reader.setParameterValues(this.parameterValues);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setSaveState(this.saveState);
        reader.setName(this.name);
        return reader;
    }
}

