/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.SqlPagingQueryUtils;
import org.springframework.batch.item.database.support.SqlWindowingPagingQueryProvider;
import org.springframework.util.StringUtils;

public class SqlServerPagingQueryProvider
extends SqlWindowingPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateTopSqlQuery(this, false, this.buildTopClause(pageSize));
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        if (StringUtils.hasText(this.getGroupClause())) {
            return SqlPagingQueryUtils.generateGroupedTopSqlQuery(this, true, this.buildTopClause(pageSize));
        }
        return SqlPagingQueryUtils.generateTopSqlQuery(this, true, this.buildTopClause(pageSize));
    }

    @Override
    protected Object getSubQueryAlias() {
        return "AS TMP_SUB ";
    }

    private String buildTopClause(int pageSize) {
        return "TOP " + pageSize;
    }
}

