/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.policy;

import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.context.RepeatContextSupport;
import org.springframework.batch.repeat.policy.CompletionPolicySupport;

public class TimeoutTerminationPolicy
extends CompletionPolicySupport {
    public static final long DEFAULT_TIMEOUT = 30000L;
    private long timeout = 30000L;

    public TimeoutTerminationPolicy() {
    }

    public TimeoutTerminationPolicy(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isComplete(RepeatContext context) {
        return ((TimeoutBatchContext)context).isComplete();
    }

    @Override
    public RepeatContext start(RepeatContext context) {
        return new TimeoutBatchContext(context);
    }

    protected class TimeoutBatchContext
    extends RepeatContextSupport {
        private volatile long time;
        private final long timeout;

        public TimeoutBatchContext(RepeatContext context) {
            super(context);
            this.time = System.currentTimeMillis();
            this.timeout = TimeoutTerminationPolicy.this.timeout;
        }

        public boolean isComplete() {
            return System.currentTimeMillis() - this.time > this.timeout;
        }
    }
}

